/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.util;

import io.openbpm.bpm.engine.ProcessEngine;
import jakarta.servlet.ServletContextEvent;
import java.security.AccessController;

public class ClassLoaderUtil {
    public static ClassLoader getContextClassloader() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getClassloader(Class<?> clazz) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(clazz::getClassLoader);
        }
        return clazz.getClassLoader();
    }

    public static void setContextClassloader(ClassLoader classLoader) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            });
        } else {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static ClassLoader getServletContextClassloader(ServletContextEvent sce) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> sce.getServletContext().getClassLoader());
        }
        return sce.getServletContext().getClassLoader();
    }

    public static ClassLoader switchToProcessEngineClassloader() {
        ClassLoader currentClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ProcessEngine.class.getClassLoader());
        return currentClassloader;
    }
}

