/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.util;

import io.openbpm.bpm.engine.impl.pvm.PvmException;
import io.openbpm.bpm.engine.impl.util.IoUtil;
import io.openbpm.bpm.engine.impl.util.ReflectUtil;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

@Deprecated(forRemoval=true, since="1.0")
public final class LogUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Map<Long, String> threadIndents = new HashMap<Long, String>();
    private static ThreadLogMode threadLogMode = ThreadLogMode.NONE;

    private LogUtil() {
    }

    public static ThreadLogMode getThreadLogMode() {
        return threadLogMode;
    }

    public static ThreadLogMode setThreadLogMode(ThreadLogMode threadLogMode) {
        ThreadLogMode old = LogUtil.threadLogMode;
        LogUtil.threadLogMode = threadLogMode;
        return old;
    }

    public static void readJavaUtilLoggingConfigFromClasspath() {
        InputStream inputStream = ReflectUtil.getResourceAsStream("logging.properties");
        try {
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
                String redirectCommons = LogManager.getLogManager().getProperty("redirect.commons.logging");
                if (redirectCommons != null && !"false".equalsIgnoreCase(redirectCommons)) {
                    System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
                }
            }
        }
        catch (Exception e) {
            throw new PvmException("couldn't initialize logging properly", e);
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    public static void resetThreadIndents() {
        threadIndents = new HashMap<Long, String>();
    }

    public static enum ThreadLogMode {
        NONE,
        INDENT,
        PRINT_ID;

    }

    public static class LogFormatter
    extends Formatter {
        private final Format dateFormat = new SimpleDateFormat("HH:mm:ss,SSS");

        @Override
        public String format(LogRecord logRecord) {
            StringBuilder line = new StringBuilder();
            line.append(this.dateFormat.format(new Date()));
            if (Level.FINE.equals(logRecord.getLevel())) {
                line.append(" FIN ");
            } else if (Level.FINEST.equals(logRecord.getLevel())) {
                line.append(" FST ");
            } else if (Level.INFO.equals(logRecord.getLevel())) {
                line.append(" INF ");
            } else if (Level.SEVERE.equals(logRecord.getLevel())) {
                line.append(" SEV ");
            } else if (Level.WARNING.equals(logRecord.getLevel())) {
                line.append(" WRN ");
            } else if (Level.FINER.equals(logRecord.getLevel())) {
                line.append(" FNR ");
            } else if (Level.CONFIG.equals(logRecord.getLevel())) {
                line.append(" CFG ");
            }
            long threadId = logRecord.getLongThreadID();
            String threadIndent = LogFormatter.getThreadIndent(threadId);
            line.append(threadIndent);
            line.append(" | ");
            line.append(logRecord.getMessage());
            if (logRecord.getThrown() != null) {
                line.append(LINE_SEPARATOR);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                line.append(stringWriter);
            }
            line.append("  [");
            line.append(logRecord.getLoggerName());
            line.append("]");
            line.append(LINE_SEPARATOR);
            return line.toString();
        }

        protected static String getThreadIndent(long threadId) {
            Long threadIdInteger = threadId;
            if (threadLogMode == ThreadLogMode.NONE) {
                return "";
            }
            if (threadLogMode == ThreadLogMode.PRINT_ID) {
                return "" + threadId;
            }
            return threadIndents.computeIfAbsent(threadIdInteger, i -> "  ".repeat(threadIndents.size()));
        }
    }
}

