/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.variable.serializer;

import io.openbpm.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import io.openbpm.bpm.engine.impl.variable.serializer.ValueFields;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.impl.value.UntypedValueImpl;
import io.openbpm.bpm.engine.variable.type.ValueType;
import io.openbpm.bpm.engine.variable.value.DateValue;
import java.util.Date;

public class DateValueSerializer
extends PrimitiveValueSerializer<DateValue> {
    public DateValueSerializer() {
        super(ValueType.DATE);
    }

    @Override
    public DateValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return Variables.dateValue((Date)((Date)untypedValue.getValue()), (boolean)untypedValue.isTransient());
    }

    @Override
    public DateValue readValue(ValueFields valueFields, boolean asTransientValue) {
        Long longValue = valueFields.getLongValue();
        Date dateValue = null;
        if (longValue != null) {
            dateValue = new Date(longValue);
        }
        return Variables.dateValue(dateValue, (boolean)asTransientValue);
    }

    @Override
    public void writeValue(DateValue typedValue, ValueFields valueFields) {
        Date dateValue = (Date)typedValue.getValue();
        if (dateValue != null) {
            valueFields.setLongValue(dateValue.getTime());
        } else {
            valueFields.setLongValue(null);
        }
    }
}

