/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.variable.serializer;

import io.openbpm.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;
import io.openbpm.bpm.engine.impl.variable.serializer.ValueFields;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.impl.value.FileValueImpl;
import io.openbpm.bpm.engine.variable.impl.value.UntypedValueImpl;
import io.openbpm.bpm.engine.variable.type.ValueType;
import io.openbpm.bpm.engine.variable.value.FileValue;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import io.openbpm.bpm.engine.variable.value.builder.FileValueBuilder;
import java.util.Arrays;

public class FileValueSerializer
extends AbstractTypedValueSerializer<FileValue> {
    protected static final int NR_OF_VALUES_IN_TEXTFIELD2 = 2;
    protected static final String MIMETYPE_ENCODING_SEPARATOR = "#";

    public FileValueSerializer() {
        super((ValueType)ValueType.FILE);
    }

    @Override
    public void writeValue(FileValue value, ValueFields valueFields) {
        byte[] data = ((FileValueImpl)value).getByteArray();
        valueFields.setByteArrayValue(data);
        valueFields.setTextValue(value.getFilename());
        if (value.getMimeType() == null && value.getEncoding() != null) {
            valueFields.setTextValue2(MIMETYPE_ENCODING_SEPARATOR + value.getEncoding());
        } else if (value.getMimeType() != null && value.getEncoding() == null) {
            valueFields.setTextValue2(value.getMimeType() + MIMETYPE_ENCODING_SEPARATOR);
        } else if (value.getMimeType() != null && value.getEncoding() != null) {
            valueFields.setTextValue2(value.getMimeType() + MIMETYPE_ENCODING_SEPARATOR + value.getEncoding());
        }
    }

    @Override
    public FileValue convertToTypedValue(UntypedValueImpl untypedValue) {
        throw new UnsupportedOperationException("Currently no automatic conversation from UntypedValue to FileValue");
    }

    @Override
    public FileValue readValue(ValueFields valueFields, boolean deserializeValue, boolean asTransientValue) {
        String fileName = valueFields.getTextValue();
        if (fileName == null) {
            fileName = "";
        }
        FileValueBuilder builder = Variables.fileValue((String)fileName);
        if (valueFields.getByteArrayValue() != null) {
            builder.file(valueFields.getByteArrayValue());
        }
        if (valueFields.getTextValue2() != null) {
            String[] split = Arrays.copyOf(valueFields.getTextValue2().split(MIMETYPE_ENCODING_SEPARATOR, 2), 2);
            String mimeType = this.returnNullIfEmptyString(split[0]);
            String encoding = this.returnNullIfEmptyString(split[1]);
            builder.mimeType(mimeType);
            builder.encoding(encoding);
        }
        builder.setTransient(asTransientValue);
        return (FileValue)builder.create();
    }

    protected String returnNullIfEmptyString(String s) {
        if (s.isEmpty()) {
            return null;
        }
        return s;
    }

    @Override
    public String getName() {
        return this.valueType.getName();
    }

    @Override
    protected boolean canWriteValue(TypedValue value) {
        if (value == null || value.getType() == null) {
            return false;
        }
        return value.getType().getName().equals(this.getName());
    }
}

