/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.xml;

import io.openbpm.bpm.engine.BpmnParseException;
import io.openbpm.bpm.engine.Problem;
import io.openbpm.bpm.engine.impl.util.xml.Element;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXParseException;

public class ProblemImpl
implements Problem {
    protected String message;
    protected int line;
    protected int column;
    protected String mainElementId;
    protected List<String> elementIds = new ArrayList<String>();

    public ProblemImpl(SAXParseException e) {
        this.concatenateErrorMessages(e);
        this.line = e.getLineNumber();
        this.column = e.getColumnNumber();
    }

    public ProblemImpl(String errorMessage, Element element) {
        this.message = errorMessage;
        this.extractElementDetails(element);
    }

    public ProblemImpl(String errorMessage, Element element, String ... elementIds) {
        this(errorMessage, element);
        this.mainElementId = elementIds[0];
        for (String elementId : elementIds) {
            if (elementId == null || elementId.isEmpty()) continue;
            this.elementIds.add(elementId);
        }
    }

    public ProblemImpl(BpmnParseException exception) {
        this.concatenateErrorMessages(exception);
        this.extractElementDetails(exception.getElement());
    }

    public ProblemImpl(BpmnParseException exception, String elementId) {
        this(exception);
        this.mainElementId = elementId;
        if (elementId != null && !elementId.isEmpty()) {
            this.elementIds.add(elementId);
        }
    }

    protected void concatenateErrorMessages(Throwable throwable) {
        StringBuilder concatenatedMessage = new StringBuilder();
        while (throwable != null) {
            if (concatenatedMessage.isEmpty()) {
                concatenatedMessage.append(throwable.getMessage());
            } else {
                concatenatedMessage.append(": ").append(throwable.getMessage());
            }
            throwable = throwable.getCause();
        }
        this.message = concatenatedMessage.toString();
    }

    protected void extractElementDetails(Element element) {
        if (element != null) {
            this.line = element.getLine();
            this.column = element.getColumn();
            String id = element.attribute("id");
            if (id != null && !id.isEmpty()) {
                this.mainElementId = id;
                this.elementIds.add(id);
            }
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public String getMainElementId() {
        return this.mainElementId;
    }

    @Override
    public List<String> getElementIds() {
        return this.elementIds;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        if (this.line > 0) {
            string.append(" | line ").append(this.line);
        }
        if (this.column > 0) {
            string.append(" | column ").append(this.column);
        }
        return string.toString();
    }
}

