/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.repository;

import io.openbpm.bpm.engine.repository.Deployment;
import io.openbpm.bpm.engine.repository.DeploymentWithDefinitions;
import io.openbpm.bpm.model.bpmn.BpmnModelInstance;
import io.openbpm.bpm.model.cmmn.CmmnModelInstance;
import io.openbpm.bpm.model.dmn.DmnModelInstance;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipInputStream;

public interface DeploymentBuilder {
    public DeploymentBuilder addInputStream(String var1, InputStream var2);

    public DeploymentBuilder addClasspathResource(String var1);

    public DeploymentBuilder addString(String var1, String var2);

    public DeploymentBuilder addModelInstance(String var1, BpmnModelInstance var2);

    public DeploymentBuilder addModelInstance(String var1, DmnModelInstance var2);

    public DeploymentBuilder addModelInstance(String var1, CmmnModelInstance var2);

    public DeploymentBuilder addZipInputStream(ZipInputStream var1);

    public DeploymentBuilder addDeploymentResources(String var1);

    public DeploymentBuilder addDeploymentResourceById(String var1, String var2);

    public DeploymentBuilder addDeploymentResourcesById(String var1, List<String> var2);

    public DeploymentBuilder addDeploymentResourceByName(String var1, String var2);

    public DeploymentBuilder addDeploymentResourcesByName(String var1, List<String> var2);

    public DeploymentBuilder name(String var1);

    public DeploymentBuilder nameFromDeployment(String var1);

    @Deprecated(forRemoval=true, since="1.0")
    default public DeploymentBuilder enableDuplicateFiltering() {
        return this.enableDuplicateFiltering(false);
    }

    public DeploymentBuilder enableDuplicateFiltering(boolean var1);

    public DeploymentBuilder activateProcessDefinitionsOn(Date var1);

    public DeploymentBuilder source(String var1);

    public Deployment deploy();

    public DeploymentWithDefinitions deployWithResult();

    public Collection<String> getResourceNames();

    public DeploymentBuilder tenantId(String var1);
}

