/*
 * Decompiled with CFR 0.152.
 */
package openbpmjar.impl.com.cronutils.model.definition;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import openbpmjar.impl.com.cronutils.model.definition.CronConstraint;
import openbpmjar.impl.com.cronutils.model.definition.CronNicknames;
import openbpmjar.impl.com.cronutils.model.field.CronFieldName;
import openbpmjar.impl.com.cronutils.model.field.definition.FieldDefinition;
import openbpmjar.impl.com.cronutils.utils.Preconditions;

public class CronDefinition
implements Serializable {
    private static final long serialVersionUID = 7067112327461432170L;
    private final Map<CronFieldName, FieldDefinition> fieldDefinitions;
    private final Set<CronConstraint> cronConstraints;
    private final Set<CronNicknames> cronNicknames;
    private final boolean matchDayOfWeekAndDayOfMonth;

    public CronDefinition(List<FieldDefinition> fieldDefinitions, Set<CronConstraint> cronConstraints, Set<CronNicknames> cronNicknames, boolean matchDayOfWeekAndDayOfMonth) {
        Preconditions.checkNotNull(cronNicknames, "Cron nicknames must not be null");
        if (!cronNicknames.contains((Object)CronNicknames.REBOOT)) {
            Preconditions.checkNotNull(fieldDefinitions, "Field definitions must not be null");
            Preconditions.checkNotNull(cronConstraints, "Cron validations must not be null");
            Preconditions.checkNotNullNorEmpty(fieldDefinitions, (Object)"Field definitions must not be empty");
            Preconditions.checkArgument(!fieldDefinitions.get(0).isOptional(), "The first field must not be optional");
        }
        this.fieldDefinitions = new EnumMap<CronFieldName, FieldDefinition>(CronFieldName.class);
        for (FieldDefinition field : fieldDefinitions) {
            this.fieldDefinitions.put(field.getFieldName(), field);
        }
        this.cronConstraints = Collections.unmodifiableSet(cronConstraints);
        this.cronNicknames = Collections.unmodifiableSet(cronNicknames);
        this.matchDayOfWeekAndDayOfMonth = matchDayOfWeekAndDayOfMonth;
    }

    public boolean isMatchDayOfWeekAndDayOfMonth() {
        return this.matchDayOfWeekAndDayOfMonth;
    }

    public Set<FieldDefinition> getFieldDefinitions() {
        return new HashSet<FieldDefinition>(this.fieldDefinitions.values());
    }

    public Map<CronFieldName, FieldDefinition> retrieveFieldDefinitionsAsMap() {
        return Collections.unmodifiableMap(this.fieldDefinitions);
    }

    public FieldDefinition getFieldDefinition(CronFieldName cronFieldName) {
        return this.fieldDefinitions.get((Object)cronFieldName);
    }

    public boolean containsFieldDefinition(CronFieldName cronFieldName) {
        return this.fieldDefinitions.containsKey((Object)cronFieldName);
    }

    public Set<CronConstraint> getCronConstraints() {
        return this.cronConstraints;
    }

    public Set<CronNicknames> getCronNicknames() {
        return this.cronNicknames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CronDefinition that = (CronDefinition)o;
        return this.matchDayOfWeekAndDayOfMonth == that.matchDayOfWeekAndDayOfMonth && this.fieldDefinitions.equals(that.fieldDefinitions) && this.cronConstraints.equals(that.cronConstraints) && this.cronNicknames.equals(that.cronNicknames);
    }

    public int hashCode() {
        return Objects.hash(this.fieldDefinitions, this.cronConstraints, this.cronNicknames, this.matchDayOfWeekAndDayOfMonth);
    }
}

