/*
 * Decompiled with CFR 0.152.
 */
package openbpmjar.impl.com.cronutils.model.time.generator;

import java.util.ArrayList;
import java.util.List;
import openbpmjar.impl.com.cronutils.mapper.WeekDay;
import openbpmjar.impl.com.cronutils.model.field.CronField;
import openbpmjar.impl.com.cronutils.model.field.CronFieldName;
import openbpmjar.impl.com.cronutils.model.field.expression.And;
import openbpmjar.impl.com.cronutils.model.field.expression.FieldExpression;
import openbpmjar.impl.com.cronutils.model.time.generator.FieldValueGenerator;
import openbpmjar.impl.com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import openbpmjar.impl.com.cronutils.model.time.generator.NoSuchValueException;
import openbpmjar.impl.com.cronutils.utils.Preconditions;

class AndDayOfWeekValueGenerator
extends FieldValueGenerator {
    private final int year;
    private final int month;
    private final WeekDay mondayDoWValue;

    public AndDayOfWeekValueGenerator(CronField cronField, int year, int month, WeekDay mondayDoWValue) {
        super(cronField);
        Preconditions.checkArgument(CronFieldName.DAY_OF_WEEK.equals((Object)cronField.getField()), "CronField does not belong to day of week");
        this.year = year;
        this.month = month;
        this.mondayDoWValue = mondayDoWValue;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        And and = (And)this.cronField.getExpression();
        for (FieldExpression expression : and.getExpressions()) {
            CronField cronField = new CronField(CronFieldName.DAY_OF_WEEK, expression, this.cronField.getConstraints());
            List<Integer> candidatesList = FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(cronField, this.year, this.month, this.mondayDoWValue).generateCandidates(start, end);
            if (candidatesList == null) continue;
            values.addAll(candidatesList);
        }
        return values;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof And;
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        return 0;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        return 0;
    }

    @Override
    public boolean isMatch(int value) {
        return false;
    }
}

