/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.bpmn.builder;

import io.openbpm.bpm.model.bpmn.BpmnModelInstance;
import io.openbpm.bpm.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.openbpm.bpm.model.bpmn.builder.BoundaryEventBuilder;
import io.openbpm.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.openbpm.bpm.model.bpmn.instance.Activity;
import io.openbpm.bpm.model.bpmn.instance.BaseElement;
import io.openbpm.bpm.model.bpmn.instance.BoundaryEvent;
import io.openbpm.bpm.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import io.openbpm.bpm.model.bpmn.instance.bpmndi.BpmnShape;
import io.openbpm.bpm.model.bpmn.instance.dc.Bounds;
import io.openbpm.bpm.model.bpmn.instance.operaton.OperatonInputOutput;
import io.openbpm.bpm.model.bpmn.instance.operaton.OperatonInputParameter;
import io.openbpm.bpm.model.bpmn.instance.operaton.OperatonOutputParameter;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractActivityBuilder<B extends AbstractActivityBuilder<B, E>, E extends Activity>
extends AbstractFlowNodeBuilder<B, E> {
    protected AbstractActivityBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    public BoundaryEventBuilder boundaryEvent() {
        return this.boundaryEvent(null);
    }

    public BoundaryEventBuilder boundaryEvent(String id) {
        BoundaryEvent boundaryEvent = this.createSibling(BoundaryEvent.class, id);
        boundaryEvent.setAttachedTo((Activity)this.element);
        BpmnShape boundaryEventBpmnShape = this.createBpmnShape(boundaryEvent);
        this.setBoundaryEventCoordinates(boundaryEventBpmnShape);
        return boundaryEvent.builder();
    }

    public MultiInstanceLoopCharacteristicsBuilder multiInstance() {
        MultiInstanceLoopCharacteristics miCharacteristics = this.createChild(MultiInstanceLoopCharacteristics.class);
        return miCharacteristics.builder();
    }

    public B operatonInputParameter(String name, String value) {
        OperatonInputOutput operatonInputOutput = this.getCreateSingleExtensionElement(OperatonInputOutput.class);
        OperatonInputParameter operatonInputParameter = this.createChild(operatonInputOutput, OperatonInputParameter.class);
        operatonInputParameter.setOperatonName(name);
        operatonInputParameter.setTextContent(value);
        return (B)((AbstractActivityBuilder)this.myself);
    }

    public B operatonOutputParameter(String name, String value) {
        OperatonInputOutput operatonInputOutput = this.getCreateSingleExtensionElement(OperatonInputOutput.class);
        OperatonOutputParameter operatonOutputParameter = this.createChild(operatonInputOutput, OperatonOutputParameter.class);
        operatonOutputParameter.setOperatonName(name);
        operatonOutputParameter.setTextContent(value);
        return (B)((AbstractActivityBuilder)this.myself);
    }

    protected double calculateXCoordinate(Bounds boundaryEventBounds) {
        BpmnShape attachedToElement = this.findBpmnShape((BaseElement)this.element);
        double x = 0.0;
        if (attachedToElement != null) {
            Bounds attachedToBounds = attachedToElement.getBounds();
            Collection boundaryEvents = ((Activity)this.element).getParentElement().getChildElementsByType(BoundaryEvent.class);
            ArrayList<BoundaryEvent> attachedBoundaryEvents = new ArrayList<BoundaryEvent>();
            for (BoundaryEvent tmp : boundaryEvents) {
                if (!tmp.getAttachedTo().equals(this.element)) continue;
                attachedBoundaryEvents.add(tmp);
            }
            double attachedToX = attachedToBounds.getX();
            double attachedToWidth = attachedToBounds.getWidth();
            double boundaryWidth = boundaryEventBounds.getWidth();
            switch (attachedBoundaryEvents.size()) {
                case 2: {
                    x = attachedToX + attachedToWidth / 2.0 + boundaryWidth / 2.0;
                    break;
                }
                case 3: {
                    x = attachedToX + attachedToWidth / 2.0 - 1.5 * boundaryWidth;
                    break;
                }
                default: {
                    x = attachedToX + attachedToWidth / 2.0 - boundaryWidth / 2.0;
                }
            }
        }
        return x;
    }

    protected void setBoundaryEventCoordinates(BpmnShape bpmnShape) {
        BpmnShape activity = this.findBpmnShape((BaseElement)this.element);
        Bounds boundaryBounds = bpmnShape.getBounds();
        double x = 0.0;
        double y = 0.0;
        if (activity != null) {
            Bounds activityBounds = activity.getBounds();
            double activityY = activityBounds.getY();
            double activityHeight = activityBounds.getHeight();
            double boundaryHeight = boundaryBounds.getHeight();
            x = this.calculateXCoordinate(boundaryBounds);
            y = activityY + activityHeight - boundaryHeight / 2.0;
        }
        boundaryBounds.setX(x);
        boundaryBounds.setY(y);
    }
}

