/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.identity.impl.ldap.util;

import io.openbpm.bpm.engine.impl.db.DbEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.UserEntity;
import io.openbpm.commons.logging.BaseLogger;
import javax.naming.directory.SearchResult;

public class LdapPluginLogger
extends BaseLogger {
    public static final String PROJECT_CODE = "LDAP";
    public static final LdapPluginLogger INSTANCE = (LdapPluginLogger)BaseLogger.createLogger(LdapPluginLogger.class, (String)"LDAP", (String)"io.openbpm.bpm.identity.impl.ldap", (String)"00");

    public void pluginActivated(String pluginClassName, String engineName) {
        this.logInfo("001", "PLUGIN {} activated on process engine {}", new Object[]{pluginClassName, engineName});
    }

    public void acceptingUntrustedCertificates() {
        this.logWarn("002", "Enabling accept of untrusted certificates. Use at own risk.", new Object[0]);
    }

    public void exceptionWhenClosingLdapContext(Exception e) {
        this.logDebug("003", "exception while closing LDAP DIR CTX", new Object[]{e});
    }

    public <E extends DbEntity> void invalidLdapEntityReturned(E entity, SearchResult searchResult) {
        String entityType = entity instanceof UserEntity ? "user" : "group";
        this.logError("004", "LDAP {} query returned a {} with id null. This {} will be ignored. This indicates a misconfiguration of the LDAP plugin or a problem with the LDAP service. Enable DEBUG/FINE logging for details.", new Object[]{entityType, entityType, entityType});
        this.logDebug("004", "Invalid {}: {} based on search result {}", new Object[]{entityType, entity, searchResult});
    }

    public void queryResult(String summary) {
        this.logDebug("005", summary, new Object[0]);
    }
}

