/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateBuilder;
import jakarta.ws.rs.core.Response;

public class SuspensionStateDto {
    private boolean suspended;

    public boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public static SuspensionStateDto fromState(boolean suspended) {
        SuspensionStateDto dto = new SuspensionStateDto();
        dto.suspended = suspended;
        return dto;
    }

    public void updateSuspensionState(ProcessEngine engine) {
        this.updateSuspensionState(engine, null);
    }

    public void updateSuspensionState(ProcessEngine engine, String processInstanceId) {
        UpdateProcessInstanceSuspensionStateBuilder updateSuspensionStateBuilder = null;
        if (processInstanceId == null) {
            String message = "Specify processInstance with processInstanceId";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        updateSuspensionStateBuilder = engine.getRuntimeService().updateProcessInstanceSuspensionState().byProcessInstanceId(processInstanceId);
        if (this.getSuspended()) {
            updateSuspensionStateBuilder.suspend();
        } else {
            updateSuspensionStateBuilder.activate();
        }
    }
}

