/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.converter;

import io.openbpm.bpm.engine.rest.dto.converter.JacksonAwareStringToTypeConverter;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.Response;
import java.util.Date;

public class DateConverter
extends JacksonAwareStringToTypeConverter<Date> {
    @Override
    public Date convertQueryParameterToType(String value) {
        if (value != null && (value.startsWith("\"") || value.endsWith("\""))) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Cannot convert value %s to java type %s because of double quotes".formatted(value, Date.class.getName()));
        }
        return this.mapToType("\"" + value + "\"", Date.class);
    }
}

