/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.converter;

import io.openbpm.bpm.engine.history.DurationReportResult;
import io.openbpm.bpm.engine.history.ReportResult;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.Response;
import java.util.List;

public final class ReportResultToCsvConverter {
    protected static final String DELIMITER = ",";
    protected static final String NEW_LINE_SEPARATOR = "\n";
    public static final String DURATION_HEADER = "PERIOD,PERIOD_UNIT,MINIMUM,MAXIMUM,AVERAGE";

    private ReportResultToCsvConverter() {
    }

    public static String convertReportResult(List<ReportResult> reports, String reportType) {
        if ("duration".equals(reportType)) {
            return ReportResultToCsvConverter.convertDurationReportResult(reports);
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Unkown report type " + reportType);
    }

    protected static String convertDurationReportResult(List<ReportResult> reports) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(DURATION_HEADER);
        for (ReportResult report : reports) {
            DurationReportResult durationReport = (DurationReportResult)report;
            buffer.append(NEW_LINE_SEPARATOR);
            buffer.append(durationReport.getPeriod());
            buffer.append(DELIMITER);
            buffer.append(durationReport.getPeriodUnit().toString());
            buffer.append(DELIMITER);
            buffer.append(durationReport.getMinimum());
            buffer.append(DELIMITER);
            buffer.append(durationReport.getMaximum());
            buffer.append(DELIMITER);
            buffer.append(durationReport.getAverage());
        }
        return buffer.toString();
    }
}

