/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricDecisionInstanceQuery;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.DateConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringArrayConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class HistoricDecisionInstanceQueryDto
extends AbstractQueryDto<HistoricDecisionInstanceQuery> {
    public static final String SORT_BY_EVALUATION_TIME_VALUE = "evaluationTime";
    public static final String SORT_BY_TENANT_ID = "tenantId";
    public static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String decisionInstanceId;
    protected String[] decisionInstanceIdIn;
    protected String decisionDefinitionId;
    protected String[] decisionDefinitionIdIn;
    protected String decisionDefinitionKey;
    protected String[] decisionDefinitionKeyIn;
    protected String decisionDefinitionName;
    protected String decisionDefinitionNameLike;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processInstanceId;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected String caseInstanceId;
    protected String[] activityIdIn;
    protected String[] activityInstanceIdIn;
    protected Date evaluatedBefore;
    protected Date evaluatedAfter;
    protected String userId;
    protected Boolean includeInputs;
    protected Boolean includeOutputs;
    protected Boolean disableBinaryFetching;
    protected Boolean disableCustomObjectDeserialization;
    protected String rootDecisionInstanceId;
    protected Boolean rootDecisionInstancesOnly;
    protected String decisionRequirementsDefinitionId;
    protected String decisionRequirementsDefinitionKey;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;

    public HistoricDecisionInstanceQueryDto() {
    }

    public HistoricDecisionInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="decisionInstanceId")
    public void setDecisionInstanceId(String decisionInstanceId) {
        this.decisionInstanceId = decisionInstanceId;
    }

    @OperatonQueryParam(value="decisionInstanceIdIn", converter=StringArrayConverter.class)
    public void setDecisionInstanceIdIn(String[] decisionInstanceIdIn) {
        this.decisionInstanceIdIn = decisionInstanceIdIn;
    }

    @OperatonQueryParam(value="decisionDefinitionId")
    public void setDecisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    @OperatonQueryParam(value="decisionDefinitionIdIn", converter=StringArrayConverter.class)
    public void setDecisionDefinitionIdIn(String[] decisionDefinitionIdIn) {
        this.decisionDefinitionIdIn = decisionDefinitionIdIn;
    }

    @OperatonQueryParam(value="decisionDefinitionKey")
    public void setDecisionDefinitionKey(String decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    @OperatonQueryParam(value="decisionDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setDecisionDefinitionKeyIn(String[] decisionDefinitionKeyIn) {
        this.decisionDefinitionKeyIn = decisionDefinitionKeyIn;
    }

    @OperatonQueryParam(value="decisionDefinitionName")
    public void setDecisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
    }

    @OperatonQueryParam(value="decisionDefinitionNameLike")
    public void setDecisionDefinitionNameLike(String decisionDefinitionNameLike) {
        this.decisionDefinitionNameLike = decisionDefinitionNameLike;
    }

    @OperatonQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OperatonQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @OperatonQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @OperatonQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @OperatonQueryParam(value="caseDefinitionKey")
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @OperatonQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @OperatonQueryParam(value="activityIdIn", converter=StringArrayConverter.class)
    public void setActivityIdIn(String[] activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    @OperatonQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    @OperatonQueryParam(value="evaluatedBefore", converter=DateConverter.class)
    public void setEvaluatedBefore(Date evaluatedBefore) {
        this.evaluatedBefore = evaluatedBefore;
    }

    @OperatonQueryParam(value="evaluatedAfter", converter=DateConverter.class)
    public void setEvaluatedAfter(Date evaluatedAfter) {
        this.evaluatedAfter = evaluatedAfter;
    }

    @OperatonQueryParam(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @OperatonQueryParam(value="includeInputs", converter=BooleanConverter.class)
    public void setIncludeInputs(Boolean includeInputs) {
        this.includeInputs = includeInputs;
    }

    @OperatonQueryParam(value="includeOutputs", converter=BooleanConverter.class)
    public void setIncludeOutputs(Boolean includeOutputs) {
        this.includeOutputs = includeOutputs;
    }

    @OperatonQueryParam(value="disableBinaryFetching", converter=BooleanConverter.class)
    public void setDisableBinaryFetching(Boolean disableBinaryFetching) {
        this.disableBinaryFetching = disableBinaryFetching;
    }

    @OperatonQueryParam(value="disableCustomObjectDeserialization", converter=BooleanConverter.class)
    public void setDisableCustomObjectDeserialization(Boolean disableCustomObjectDeserialization) {
        this.disableCustomObjectDeserialization = disableCustomObjectDeserialization;
    }

    @OperatonQueryParam(value="rootDecisionInstanceId")
    public void setRootDecisionInstanceId(String rootDecisionInstanceId) {
        this.rootDecisionInstanceId = rootDecisionInstanceId;
    }

    @OperatonQueryParam(value="rootDecisionInstancesOnly", converter=BooleanConverter.class)
    public void setRootDecisionInstancesOnly(Boolean rootDecisionInstancesOnly) {
        this.rootDecisionInstancesOnly = rootDecisionInstancesOnly;
    }

    @OperatonQueryParam(value="decisionRequirementsDefinitionId")
    public void setDecisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
    }

    @OperatonQueryParam(value="decisionRequirementsDefinitionKey")
    public void setDecisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
        this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricDecisionInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricDecisionInstanceQuery();
    }

    @Override
    protected void applyFilters(HistoricDecisionInstanceQuery query) {
        if (this.decisionInstanceId != null) {
            query.decisionInstanceId(this.decisionInstanceId);
        }
        if (this.decisionInstanceIdIn != null) {
            query.decisionInstanceIdIn(this.decisionInstanceIdIn);
        }
        if (this.decisionDefinitionId != null) {
            query.decisionDefinitionId(this.decisionDefinitionId);
        }
        if (this.decisionDefinitionIdIn != null) {
            query.decisionDefinitionIdIn(this.decisionDefinitionIdIn);
        }
        if (this.decisionDefinitionKey != null) {
            query.decisionDefinitionKey(this.decisionDefinitionKey);
        }
        if (this.decisionDefinitionKeyIn != null) {
            query.decisionDefinitionKeyIn(this.decisionDefinitionKeyIn);
        }
        if (this.decisionDefinitionName != null) {
            query.decisionDefinitionName(this.decisionDefinitionName);
        }
        if (this.decisionDefinitionNameLike != null) {
            query.decisionDefinitionNameLike(this.decisionDefinitionNameLike);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.caseDefinitionKey != null) {
            query.caseDefinitionKey(this.caseDefinitionKey);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.activityIdIn != null) {
            query.activityIdIn(this.activityIdIn);
        }
        if (this.activityInstanceIdIn != null) {
            query.activityInstanceIdIn(this.activityInstanceIdIn);
        }
        if (this.evaluatedBefore != null) {
            query.evaluatedBefore(this.evaluatedBefore);
        }
        if (this.evaluatedAfter != null) {
            query.evaluatedAfter(this.evaluatedAfter);
        }
        if (this.userId != null) {
            query.userId(this.userId);
        }
        if (Boolean.TRUE.equals(this.includeInputs)) {
            query.includeInputs();
        }
        if (Boolean.TRUE.equals(this.includeOutputs)) {
            query.includeOutputs();
        }
        if (Boolean.TRUE.equals(this.disableBinaryFetching)) {
            query.disableBinaryFetching();
        }
        if (Boolean.TRUE.equals(this.disableCustomObjectDeserialization)) {
            query.disableCustomObjectDeserialization();
        }
        if (this.rootDecisionInstanceId != null) {
            query.rootDecisionInstanceId(this.rootDecisionInstanceId);
        }
        if (Boolean.TRUE.equals(this.rootDecisionInstancesOnly)) {
            query.rootDecisionInstancesOnly();
        }
        if (this.decisionRequirementsDefinitionId != null) {
            query.decisionRequirementsDefinitionId(this.decisionRequirementsDefinitionId);
        }
        if (this.decisionRequirementsDefinitionKey != null) {
            query.decisionRequirementsDefinitionKey(this.decisionRequirementsDefinitionKey);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
    }

    @Override
    protected void applySortBy(HistoricDecisionInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_EVALUATION_TIME_VALUE.equals(sortBy)) {
            query.orderByEvaluationTime();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_EVALUATION_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

