/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricVariableInstanceQuery;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringArrayConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HistoricVariableInstanceQueryDto
extends AbstractQueryDto<HistoricVariableInstanceQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_VARIABLE_NAME_VALUE = "variableName";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String caseInstanceId;
    protected String variableName;
    protected String variableNameLike;
    protected Object variableValue;
    protected Boolean variableValuesIgnoreCase;
    protected Boolean variableNamesIgnoreCase;
    protected String[] variableTypeIn;
    protected String[] executionIdIn;
    protected String[] taskIdIn;
    protected String[] activityInstanceIdIn;
    protected String[] caseExecutionIdIn;
    protected String[] caseActivityIdIn;
    protected String[] processInstanceIdIn;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected boolean includeDeleted;
    protected String[] variableNameIn;

    public HistoricVariableInstanceQueryDto() {
    }

    public HistoricVariableInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @OperatonQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OperatonQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @OperatonQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @OperatonQueryParam(value="variableName")
    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    @OperatonQueryParam(value="variableNameLike")
    public void setVariableNameLike(String variableNameLike) {
        this.variableNameLike = variableNameLike;
    }

    @OperatonQueryParam(value="variableValue")
    public void setVariableValue(Object variableValue) {
        this.variableValue = variableValue;
    }

    @OperatonQueryParam(value="variableTypeIn", converter=StringArrayConverter.class)
    public void setVariableTypeIn(String[] variableTypeIn) {
        this.variableTypeIn = variableTypeIn;
    }

    @OperatonQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    @OperatonQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    @OperatonQueryParam(value="executionIdIn", converter=StringArrayConverter.class)
    public void setExecutionIdIn(String[] executionIdIn) {
        this.executionIdIn = executionIdIn;
    }

    @OperatonQueryParam(value="taskIdIn", converter=StringArrayConverter.class)
    public void setTaskIdIn(String[] taskIdIn) {
        this.taskIdIn = taskIdIn;
    }

    @OperatonQueryParam(value="processInstanceIdIn", converter=StringArrayConverter.class)
    public void setProcessInstanceIdIn(String[] processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    @OperatonQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    @OperatonQueryParam(value="caseExecutionIdIn", converter=StringArrayConverter.class)
    public void setCaseExecutionIdIn(String[] caseExecutionIdIn) {
        this.caseExecutionIdIn = caseExecutionIdIn;
    }

    @OperatonQueryParam(value="caseActivityIdIn", converter=StringArrayConverter.class)
    public void setCaseActivityIdIn(String[] caseActivityIdIn) {
        this.caseActivityIdIn = caseActivityIdIn;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public boolean isIncludeDeleted() {
        return this.includeDeleted;
    }

    @OperatonQueryParam(value="includeDeleted", converter=BooleanConverter.class)
    public void setIncludeDeleted(boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    @OperatonQueryParam(value="variableNameIn", converter=StringArrayConverter.class)
    public void setVariableNameIn(String[] variableNameIn) {
        this.variableNameIn = variableNameIn;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricVariableInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricVariableInstanceQuery();
    }

    @Override
    protected void applyFilters(HistoricVariableInstanceQuery query) {
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.variableName != null) {
            query.variableName(this.variableName);
        }
        if (this.variableNameLike != null) {
            query.variableNameLike(this.variableNameLike);
        }
        if (this.variableValue != null) {
            if (this.variableName != null) {
                query.variableValueEquals(this.variableName, this.variableValue);
            } else {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only a single variable value parameter specified: variable name and value are required to be able to query after a specific variable value.");
            }
        }
        if (this.variableTypeIn != null && this.variableTypeIn.length > 0) {
            query.variableTypeIn(this.variableTypeIn);
        }
        if (Boolean.TRUE.equals(this.variableNamesIgnoreCase)) {
            query.matchVariableNamesIgnoreCase();
        }
        if (Boolean.TRUE.equals(this.variableValuesIgnoreCase)) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.executionIdIn != null && this.executionIdIn.length > 0) {
            query.executionIdIn(this.executionIdIn);
        }
        if (this.taskIdIn != null && this.taskIdIn.length > 0) {
            query.taskIdIn(this.taskIdIn);
        }
        if (this.processInstanceIdIn != null && this.processInstanceIdIn.length > 0) {
            query.processInstanceIdIn(this.processInstanceIdIn);
        }
        if (this.activityInstanceIdIn != null && this.activityInstanceIdIn.length > 0) {
            query.activityInstanceIdIn(this.activityInstanceIdIn);
        }
        if (this.caseExecutionIdIn != null && this.caseExecutionIdIn.length > 0) {
            query.caseExecutionIdIn(this.caseExecutionIdIn);
        }
        if (this.caseActivityIdIn != null && this.caseActivityIdIn.length > 0) {
            query.caseActivityIdIn(this.caseActivityIdIn);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.includeDeleted) {
            query.includeDeleted();
        }
        if (this.variableNameIn != null && this.variableNameIn.length > 0) {
            query.variableNameIn(this.variableNameIn);
        }
    }

    @Override
    protected void applySortBy(HistoricVariableInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_PROCESS_INSTANCE_ID_VALUE.equals(sortBy)) {
            query.orderByProcessInstanceId();
        } else if (SORT_BY_VARIABLE_NAME_VALUE.equals(sortBy)) {
            query.orderByVariableName();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

