/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.management;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.management.JobDefinitionQuery;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringArrayConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JobDefinitionQueryDto
extends AbstractQueryDto<JobDefinitionQuery> {
    private static final String SORT_BY_JOB_DEFINITION_ID = "jobDefinitionId";
    private static final String SORT_BY_ACTIVITY_ID = "activityId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String SORT_BY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    private static final String SORT_BY_JOB_TYPE = "jobType";
    private static final String SORT_BY_JOB_CONFIGURATION = "jobConfiguration";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String jobDefinitionId;
    protected String[] activityIdIn;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String jobType;
    protected String jobConfiguration;
    protected Boolean active;
    protected Boolean suspended;
    protected Boolean withOverridingJobPriority;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected Boolean includeJobDefinitionsWithoutTenantId;

    public JobDefinitionQueryDto() {
    }

    public JobDefinitionQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="jobDefinitionId")
    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    @OperatonQueryParam(value="activityIdIn", converter=StringArrayConverter.class)
    public void setActivityIdIn(String[] activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    @OperatonQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OperatonQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @OperatonQueryParam(value="jobType")
    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    @OperatonQueryParam(value="jobConfiguration")
    public void setJobConfiguration(String jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
    }

    @OperatonQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @OperatonQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @OperatonQueryParam(value="withOverridingJobPriority", converter=BooleanConverter.class)
    public void setWithOverridingJobPriority(Boolean withOverridingJobPriority) {
        this.withOverridingJobPriority = withOverridingJobPriority;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @OperatonQueryParam(value="includeJobDefinitionsWithoutTenantId", converter=BooleanConverter.class)
    public void setIncludeJobDefinitionsWithoutTenantId(Boolean includeJobDefinitionsWithoutTenantId) {
        this.includeJobDefinitionsWithoutTenantId = includeJobDefinitionsWithoutTenantId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected JobDefinitionQuery createNewQuery(ProcessEngine engine) {
        return engine.getManagementService().createJobDefinitionQuery();
    }

    @Override
    protected void applyFilters(JobDefinitionQuery query) {
        if (this.jobDefinitionId != null) {
            query.jobDefinitionId(this.jobDefinitionId);
        }
        if (this.activityIdIn != null && this.activityIdIn.length > 0) {
            query.activityIdIn(this.activityIdIn);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.jobType != null) {
            query.jobType(this.jobType);
        }
        if (this.jobConfiguration != null) {
            query.jobConfiguration(this.jobConfiguration);
        }
        if (Boolean.TRUE.equals(this.active)) {
            query.active();
        }
        if (Boolean.TRUE.equals(this.suspended)) {
            query.suspended();
        }
        if (Boolean.TRUE.equals(this.withOverridingJobPriority)) {
            query.withOverridingJobPriority();
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (Boolean.TRUE.equals(this.includeJobDefinitionsWithoutTenantId)) {
            query.includeJobDefinitionsWithoutTenantId();
        }
    }

    @Override
    protected void applySortBy(JobDefinitionQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_JOB_DEFINITION_ID.equals(sortBy)) {
            query.orderByJobDefinitionId();
        } else if (SORT_BY_ACTIVITY_ID.equals(sortBy)) {
            query.orderByActivityId();
        } else if (SORT_BY_PROCESS_DEFINITION_ID.equals(sortBy)) {
            query.orderByProcessDefinitionId();
        } else if (SORT_BY_PROCESS_DEFINITION_KEY.equals(sortBy)) {
            query.orderByProcessDefinitionKey();
        } else if (SORT_BY_JOB_TYPE.equals(sortBy)) {
            query.orderByJobType();
        } else if (SORT_BY_JOB_CONFIGURATION.equals(sortBy)) {
            query.orderByJobConfiguration();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_CONFIGURATION);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

