/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.repository;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.RepositoryService;
import io.openbpm.bpm.engine.impl.calendar.DateTimeUtil;
import io.openbpm.bpm.engine.rest.dto.SuspensionStateDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.Response;
import java.util.Date;

public class ProcessDefinitionSuspensionStateDto
extends SuspensionStateDto {
    private String executionDate;
    private boolean includeProcessInstances;
    private String processDefinitionId;
    private String processDefinitionKey;

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setExecutionDate(String executionDate) {
        this.executionDate = executionDate;
    }

    public void setIncludeProcessInstances(boolean includeProcessInstances) {
        this.includeProcessInstances = includeProcessInstances;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public void updateSuspensionState(ProcessEngine engine) {
        if (this.processDefinitionId != null && this.processDefinitionKey != null) {
            String message = "Only one of processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        RepositoryService repositoryService = engine.getRepositoryService();
        Date delayedExecutionDate = null;
        if (this.executionDate != null && !"".equals(this.executionDate)) {
            delayedExecutionDate = DateTimeUtil.parseDate((String)this.executionDate);
        }
        if (this.processDefinitionId != null) {
            if (this.getSuspended()) {
                repositoryService.suspendProcessDefinitionById(this.processDefinitionId, this.includeProcessInstances, delayedExecutionDate);
            } else {
                repositoryService.activateProcessDefinitionById(this.processDefinitionId, this.includeProcessInstances, delayedExecutionDate);
            }
        } else if (this.processDefinitionKey != null) {
            if (this.getSuspended()) {
                repositoryService.suspendProcessDefinitionByKey(this.processDefinitionKey, this.includeProcessInstances, delayedExecutionDate);
            } else {
                repositoryService.activateProcessDefinitionByKey(this.processDefinitionKey, this.includeProcessInstances, delayedExecutionDate);
            }
        } else {
            String message = "Either processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
    }
}

