/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.runtime;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.rest.dto.SuspensionStateDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import io.openbpm.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import io.openbpm.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateBuilder;
import io.openbpm.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateSelectBuilder;
import io.openbpm.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateTenantBuilder;
import io.openbpm.bpm.engine.runtime.UpdateProcessInstancesSuspensionStateBuilder;
import jakarta.ws.rs.core.Response;
import java.util.List;

public class ProcessInstanceSuspensionStateDto
extends SuspensionStateDto {
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQueryDto processInstanceQuery;
    protected HistoricProcessInstanceQueryDto historicProcessInstanceQuery;
    protected String processDefinitionTenantId;
    protected boolean processDefinitionWithoutTenantId;

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public ProcessInstanceQueryDto getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
    }

    public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    }

    public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    public void setProcessDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
    }

    public boolean getProcessDefinitionWithoutTenantId() {
        return this.processDefinitionWithoutTenantId;
    }

    public void setProcessDefinitionWithoutTenantId(boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
    }

    @Override
    public void updateSuspensionState(ProcessEngine engine) {
        int params = this.parameterCount(this.processDefinitionId, this.processDefinitionKey);
        int syncParams = this.parameterCount(this.processInstanceIds, this.processInstanceQuery, this.historicProcessInstanceQuery);
        if (params >= 1 && syncParams >= 1) {
            String message = "Choose either a single processInstance with processDefinitionId or processDefinitionKey or a group of processInstances with processInstanceIds, procesInstanceQuery or historicProcessInstanceQuery.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        if (params > 1) {
            String message = "Only one of processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        if (params == 0 && syncParams == 0) {
            String message = "Either processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        UpdateProcessInstanceSuspensionStateBuilder updateSuspensionStateBuilder = null;
        if (params == 1) {
            updateSuspensionStateBuilder = this.createUpdateSuspensionStateBuilder(engine);
        } else if (syncParams >= 1) {
            updateSuspensionStateBuilder = this.createUpdateSuspensionStateGroupBuilder(engine);
        }
        if (this.getSuspended()) {
            updateSuspensionStateBuilder.suspend();
        } else {
            updateSuspensionStateBuilder.activate();
        }
    }

    protected UpdateProcessInstanceSuspensionStateBuilder createUpdateSuspensionStateBuilder(ProcessEngine engine) {
        UpdateProcessInstanceSuspensionStateSelectBuilder selectBuilder = engine.getRuntimeService().updateProcessInstanceSuspensionState();
        if (this.processDefinitionId != null) {
            return selectBuilder.byProcessDefinitionId(this.processDefinitionId);
        }
        UpdateProcessInstanceSuspensionStateTenantBuilder tenantBuilder = selectBuilder.byProcessDefinitionKey(this.processDefinitionKey);
        if (this.processDefinitionTenantId != null) {
            tenantBuilder.processDefinitionTenantId(this.processDefinitionTenantId);
        } else if (this.processDefinitionWithoutTenantId) {
            tenantBuilder.processDefinitionWithoutTenantId();
        }
        return tenantBuilder;
    }

    protected UpdateProcessInstancesSuspensionStateBuilder createUpdateSuspensionStateGroupBuilder(ProcessEngine engine) {
        UpdateProcessInstanceSuspensionStateSelectBuilder selectBuilder = engine.getRuntimeService().updateProcessInstanceSuspensionState();
        UpdateProcessInstancesSuspensionStateBuilder groupBuilder = null;
        if (this.processInstanceIds != null) {
            groupBuilder = selectBuilder.byProcessInstanceIds(this.processInstanceIds);
        }
        if (this.processInstanceQuery != null) {
            if (groupBuilder == null) {
                groupBuilder = selectBuilder.byProcessInstanceQuery((ProcessInstanceQuery)this.processInstanceQuery.toQuery(engine));
            } else {
                groupBuilder.byProcessInstanceQuery((ProcessInstanceQuery)this.processInstanceQuery.toQuery(engine));
            }
        }
        if (this.historicProcessInstanceQuery != null) {
            if (groupBuilder == null) {
                groupBuilder = selectBuilder.byHistoricProcessInstanceQuery((HistoricProcessInstanceQuery)this.historicProcessInstanceQuery.toQuery(engine));
            } else {
                groupBuilder.byHistoricProcessInstanceQuery((HistoricProcessInstanceQuery)this.historicProcessInstanceQuery.toQuery(engine));
            }
        }
        return groupBuilder;
    }

    protected int parameterCount(Object ... o) {
        int count = 0;
        for (Object o1 : o) {
            count += o1 != null ? 1 : 0;
        }
        return count;
    }
}

