/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.VariableQueryParameterDto;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringArrayConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import io.openbpm.bpm.engine.rest.dto.converter.VariableListConverter;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.runtime.VariableInstanceQuery;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VariableInstanceQueryDto
extends AbstractQueryDto<VariableInstanceQuery> {
    private static final String SORT_BY_VARIABLE_NAME_VALUE = "variableName";
    private static final String SORT_BY_VARIABLE_TYPE_VALUE = "variableType";
    private static final String SORT_BY_ACTIVITY_INSTANCE_ID_VALUE = "activityInstanceId";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String variableName;
    protected String variableNameLike;
    protected List<VariableQueryParameterDto> variableValues;
    protected Boolean variableNamesIgnoreCase;
    protected Boolean variableValuesIgnoreCase;
    protected String[] executionIdIn;
    protected String[] processInstanceIdIn;
    protected String[] caseExecutionIdIn;
    protected String[] caseInstanceIdIn;
    protected String[] taskIdIn;
    protected String[] batchIdIn;
    protected String[] variableScopeIdIn;
    protected String[] activityInstanceIdIn;
    private List<String> tenantIds;

    public VariableInstanceQueryDto() {
    }

    public VariableInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="variableName")
    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    @OperatonQueryParam(value="variableNameLike")
    public void setVariableNameLike(String variableNameLike) {
        this.variableNameLike = variableNameLike;
    }

    @OperatonQueryParam(value="variableValues", converter=VariableListConverter.class)
    public void setVariableValues(List<VariableQueryParameterDto> variableValues) {
        this.variableValues = variableValues;
    }

    @OperatonQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    @OperatonQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    @OperatonQueryParam(value="executionIdIn", converter=StringArrayConverter.class)
    public void setExecutionIdIn(String[] executionIdIn) {
        this.executionIdIn = executionIdIn;
    }

    @OperatonQueryParam(value="processInstanceIdIn", converter=StringArrayConverter.class)
    public void setProcessInstanceIdIn(String[] processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    @OperatonQueryParam(value="caseExecutionIdIn", converter=StringArrayConverter.class)
    public void setCaseExecutionIdIn(String[] caseExecutionIdIn) {
        this.caseExecutionIdIn = caseExecutionIdIn;
    }

    @OperatonQueryParam(value="caseInstanceIdIn", converter=StringArrayConverter.class)
    public void setCaseInstanceIdIn(String[] caseInstanceIdIn) {
        this.caseInstanceIdIn = caseInstanceIdIn;
    }

    @OperatonQueryParam(value="taskIdIn", converter=StringArrayConverter.class)
    public void setTaskIdIn(String[] taskIdIn) {
        this.taskIdIn = taskIdIn;
    }

    @OperatonQueryParam(value="batchIdIn", converter=StringArrayConverter.class)
    public void setBatchIdIn(String[] batchIdIn) {
        this.batchIdIn = batchIdIn;
    }

    @OperatonQueryParam(value="variableScopeIdIn", converter=StringArrayConverter.class)
    public void setVariableScopeIdIn(String[] variableScopeIdIn) {
        this.variableScopeIdIn = variableScopeIdIn;
    }

    @OperatonQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected VariableInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getRuntimeService().createVariableInstanceQuery();
    }

    @Override
    protected void applyFilters(VariableInstanceQuery query) {
        if (this.variableName != null) {
            query.variableName(this.variableName);
        }
        if (this.variableNameLike != null) {
            query.variableNameLike(this.variableNameLike);
        }
        if (Boolean.TRUE.equals(this.variableNamesIgnoreCase)) {
            query.matchVariableNamesIgnoreCase();
        }
        if (Boolean.TRUE.equals(this.variableValuesIgnoreCase)) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.variableValues != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variableValues) {
                String varName = variableQueryParam.getName();
                String op = variableQueryParam.getOperator();
                Object variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if ("eq".equals(op)) {
                    query.variableValueEquals(varName, variableValue);
                    continue;
                }
                if ("gt".equals(op)) {
                    query.variableValueGreaterThan(varName, variableValue);
                    continue;
                }
                if ("gteq".equals(op)) {
                    query.variableValueGreaterThanOrEqual(varName, variableValue);
                    continue;
                }
                if ("lt".equals(op)) {
                    query.variableValueLessThan(varName, variableValue);
                    continue;
                }
                if ("lteq".equals(op)) {
                    query.variableValueLessThanOrEqual(varName, variableValue);
                    continue;
                }
                if ("neq".equals(op)) {
                    query.variableValueNotEquals(varName, variableValue);
                    continue;
                }
                if ("like".equals(op)) {
                    query.variableValueLike(varName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
        if (this.executionIdIn != null && this.executionIdIn.length > 0) {
            query.executionIdIn(this.executionIdIn);
        }
        if (this.processInstanceIdIn != null && this.processInstanceIdIn.length > 0) {
            query.processInstanceIdIn(this.processInstanceIdIn);
        }
        if (this.caseExecutionIdIn != null && this.caseExecutionIdIn.length > 0) {
            query.caseExecutionIdIn(this.caseExecutionIdIn);
        }
        if (this.caseInstanceIdIn != null && this.caseInstanceIdIn.length > 0) {
            query.caseInstanceIdIn(this.caseInstanceIdIn);
        }
        if (this.taskIdIn != null && this.taskIdIn.length > 0) {
            query.taskIdIn(this.taskIdIn);
        }
        if (this.batchIdIn != null && this.batchIdIn.length > 0) {
            query.batchIdIn(this.batchIdIn);
        }
        if (this.variableScopeIdIn != null && this.variableScopeIdIn.length > 0) {
            query.variableScopeIdIn(this.variableScopeIdIn);
        }
        if (this.activityInstanceIdIn != null && this.activityInstanceIdIn.length > 0) {
            query.activityInstanceIdIn(this.activityInstanceIdIn);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[0]));
        }
    }

    @Override
    protected void applySortBy(VariableInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_VARIABLE_NAME_VALUE.equals(sortBy)) {
            query.orderByVariableName();
        } else if (SORT_BY_VARIABLE_TYPE_VALUE.equals(sortBy)) {
            query.orderByVariableType();
        } else if (SORT_BY_ACTIVITY_INSTANCE_ID_VALUE.equals(sortBy)) {
            query.orderByActivityInstanceId();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_TYPE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

