/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.hal;

import io.openbpm.bpm.engine.rest.dto.VariableValueDto;
import io.openbpm.bpm.engine.rest.exception.RestException;
import io.openbpm.bpm.engine.rest.hal.HalRelation;
import io.openbpm.bpm.engine.rest.hal.HalResource;
import io.openbpm.bpm.engine.rest.sub.VariableResource;
import io.openbpm.bpm.engine.runtime.VariableInstance;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Map;

public class HalVariableValue
extends HalResource<HalVariableValue> {
    public static final HalRelation REL_SELF = HalRelation.build("self", VariableResource.class, UriBuilder.fromPath((String)"/{scopeResourcePath}").path("{scopeId}").path("{variablesName}").path("{variableName}"));
    private static final String VARIABLES_PATH_LOCAL_VARIABLES = "localVariables";
    private static final String VARIABLES_PATH_VARIABLES = "variables";
    protected String name;
    protected Object value;
    protected String type;
    protected Map<String, Object> valueInfo;

    public static HalVariableValue generateVariableValue(VariableInstance variableInstance, String variableScopeId) {
        if (variableScopeId.equals(variableInstance.getTaskId())) {
            return HalVariableValue.generateTaskVariableValue(variableInstance, variableScopeId);
        }
        if (variableScopeId.equals(variableInstance.getProcessInstanceId())) {
            return HalVariableValue.generateProcessInstanceVariableValue(variableInstance, variableScopeId);
        }
        if (variableScopeId.equals(variableInstance.getExecutionId())) {
            return HalVariableValue.generateExecutionVariableValue(variableInstance, variableScopeId);
        }
        if (variableScopeId.equals(variableInstance.getCaseInstanceId())) {
            return HalVariableValue.generateCaseInstanceVariableValue(variableInstance, variableScopeId);
        }
        if (variableScopeId.equals(variableInstance.getCaseExecutionId())) {
            return HalVariableValue.generateCaseExecutionVariableValue(variableInstance, variableScopeId);
        }
        throw new RestException("Variable scope id '" + variableScopeId + "' does not match with variable instance '" + variableInstance + "'");
    }

    public static HalVariableValue generateTaskVariableValue(VariableInstance variableInstance, String taskId) {
        return HalVariableValue.fromVariableInstance(variableInstance).link(REL_SELF, "/task", taskId, VARIABLES_PATH_LOCAL_VARIABLES);
    }

    public static HalVariableValue generateExecutionVariableValue(VariableInstance variableInstance, String executionId) {
        return HalVariableValue.fromVariableInstance(variableInstance).link(REL_SELF, "/execution", executionId, VARIABLES_PATH_LOCAL_VARIABLES);
    }

    public static HalVariableValue generateProcessInstanceVariableValue(VariableInstance variableInstance, String processInstanceId) {
        return HalVariableValue.fromVariableInstance(variableInstance).link(REL_SELF, "/process-instance", processInstanceId, VARIABLES_PATH_VARIABLES);
    }

    public static HalVariableValue generateCaseExecutionVariableValue(VariableInstance variableInstance, String caseExecutionId) {
        return HalVariableValue.fromVariableInstance(variableInstance).link(REL_SELF, "/case-execution", caseExecutionId, VARIABLES_PATH_LOCAL_VARIABLES);
    }

    public static HalVariableValue generateCaseInstanceVariableValue(VariableInstance variableInstance, String caseInstanceId) {
        return HalVariableValue.fromVariableInstance(variableInstance).link(REL_SELF, "/case-instance", caseInstanceId, VARIABLES_PATH_VARIABLES);
    }

    private HalVariableValue link(HalRelation relation, String resourcePath, String resourceId, String variablesPath) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        this.linker.createLink(relation, resourcePath, resourceId, variablesPath, this.name);
        return this;
    }

    public static HalVariableValue fromVariableInstance(VariableInstance variableInstance) {
        HalVariableValue dto = new HalVariableValue();
        VariableValueDto variableValueDto = VariableValueDto.fromTypedValue(variableInstance.getTypedValue());
        dto.name = variableInstance.getName();
        dto.value = variableValueDto.getValue();
        dto.type = variableValueDto.getType();
        dto.valueInfo = variableValueDto.getValueInfo();
        return dto;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getValueInfo() {
        return this.valueInfo;
    }
}

