/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.RuntimeService;
import io.openbpm.bpm.engine.rest.ConditionRestService;
import io.openbpm.bpm.engine.rest.dto.VariableValueDto;
import io.openbpm.bpm.engine.rest.dto.condition.EvaluationConditionDto;
import io.openbpm.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.openbpm.bpm.engine.runtime.ConditionEvaluationBuilder;
import io.openbpm.bpm.engine.runtime.ProcessInstance;
import io.openbpm.bpm.engine.variable.VariableMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConditionRestServiceImpl
extends AbstractRestProcessEngineAware
implements ConditionRestService {
    public ConditionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public List<ProcessInstanceDto> evaluateCondition(EvaluationConditionDto conditionDto) {
        if (conditionDto.getTenantId() != null && conditionDto.isWithoutTenantId()) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter 'tenantId' cannot be used together with parameter 'withoutTenantId'.");
        }
        ConditionEvaluationBuilder builder = this.createConditionEvaluationBuilder(conditionDto);
        List processInstances = builder.evaluateStartConditions();
        ArrayList<ProcessInstanceDto> result = new ArrayList<ProcessInstanceDto>();
        for (ProcessInstance processInstance : processInstances) {
            result.add(ProcessInstanceDto.fromProcessInstance(processInstance));
        }
        return result;
    }

    protected ConditionEvaluationBuilder createConditionEvaluationBuilder(EvaluationConditionDto conditionDto) {
        RuntimeService runtimeService = this.getProcessEngine().getRuntimeService();
        ObjectMapper objectMapper = this.getObjectMapper();
        VariableMap variables = VariableValueDto.toMap(conditionDto.getVariables(), this.getProcessEngine(), objectMapper);
        ConditionEvaluationBuilder builder = runtimeService.createConditionEvaluation();
        if (variables != null && !variables.isEmpty()) {
            builder.setVariables((Map)variables);
        }
        if (conditionDto.getBusinessKey() != null) {
            builder.processInstanceBusinessKey(conditionDto.getBusinessKey());
        }
        if (conditionDto.getProcessDefinitionId() != null) {
            builder.processDefinitionId(conditionDto.getProcessDefinitionId());
        }
        if (conditionDto.getTenantId() != null) {
            builder.tenantId(conditionDto.getTenantId());
        } else if (conditionDto.isWithoutTenantId()) {
            builder.withoutTenantId();
        }
        return builder;
    }
}

