/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricExternalTaskLog;
import io.openbpm.bpm.engine.history.HistoricExternalTaskLogQuery;
import io.openbpm.bpm.engine.rest.dto.CountResultDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricExternalTaskLogDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricExternalTaskLogQueryDto;
import io.openbpm.bpm.engine.rest.history.HistoricExternalTaskLogRestService;
import io.openbpm.bpm.engine.rest.sub.history.HistoricExternalTaskLogResource;
import io.openbpm.bpm.engine.rest.sub.history.impl.HistoricExternalTaskLogResourceImpl;
import io.openbpm.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class HistoricExternalTaskLogRestServiceImpl
implements HistoricExternalTaskLogRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricExternalTaskLogRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricExternalTaskLogResource getHistoricExternalTaskLog(String historicExternalTaskLogId) {
        return new HistoricExternalTaskLogResourceImpl(historicExternalTaskLogId, this.processEngine);
    }

    @Override
    public List<HistoricExternalTaskLogDto> getHistoricExternalTaskLogs(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricExternalTaskLogQueryDto queryDto = new HistoricExternalTaskLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricExternalTaskLogs(queryDto, firstResult, maxResults);
    }

    @Override
    public List<HistoricExternalTaskLogDto> queryHistoricExternalTaskLogs(HistoricExternalTaskLogQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricExternalTaskLogQuery query = (HistoricExternalTaskLogQuery)queryDto.toQuery(this.processEngine);
        List<HistoricExternalTaskLog> matchingHistoricExternalTaskLogs = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricExternalTaskLogDto> results = new ArrayList<HistoricExternalTaskLogDto>();
        for (HistoricExternalTaskLog historicExternalTaskLog : matchingHistoricExternalTaskLogs) {
            HistoricExternalTaskLogDto result = HistoricExternalTaskLogDto.fromHistoricExternalTaskLog(historicExternalTaskLog);
            results.add(result);
        }
        return results;
    }

    @Override
    public CountResultDto getHistoricExternalTaskLogsCount(UriInfo uriInfo) {
        HistoricExternalTaskLogQueryDto queryDto = new HistoricExternalTaskLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricExternalTaskLogsCount(queryDto);
    }

    @Override
    public CountResultDto queryHistoricExternalTaskLogsCount(HistoricExternalTaskLogQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricExternalTaskLogQuery query = (HistoricExternalTaskLogQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

