/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.authorization.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.AuthorizationService;
import io.openbpm.bpm.engine.authorization.Authorization;
import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.authorization.Resource;
import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.rest.dto.ResourceOptionsDto;
import io.openbpm.bpm.engine.rest.dto.authorization.AuthorizationDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.impl.AbstractAuthorizedRestResource;
import io.openbpm.bpm.engine.rest.sub.authorization.AuthorizationResource;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;

public class AuthorizationResourceImpl
extends AbstractAuthorizedRestResource
implements AuthorizationResource {
    protected final AuthorizationService authorizationService;

    public AuthorizationResourceImpl(String processEngineName, String resourceId, String relativeRootResourcePath, ObjectMapper objectMapper) {
        super(processEngineName, (Resource)Resources.AUTHORIZATION, resourceId, objectMapper);
        this.setRelativeRootResourceUri(relativeRootResourcePath);
        this.authorizationService = this.getProcessEngine().getAuthorizationService();
    }

    @Override
    public AuthorizationDto getAuthorization(UriInfo context) {
        Authorization dbAuthorization = this.getDbAuthorization();
        return AuthorizationDto.fromAuthorization(dbAuthorization, this.getProcessEngine().getProcessEngineConfiguration());
    }

    @Override
    public void deleteAuthorization() {
        Authorization dbAuthorization = this.getDbAuthorization();
        this.authorizationService.deleteAuthorization(dbAuthorization.getId());
    }

    @Override
    public void updateAuthorization(AuthorizationDto dto) {
        Authorization dbAuthorization = this.getDbAuthorization();
        AuthorizationDto.update(dto, dbAuthorization, this.getProcessEngine().getProcessEngineConfiguration());
        this.authorizationService.saveAuthorization(dbAuthorization);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        URI uri = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/authorization").path(this.resourceId).build(new Object[0]);
        dto.addReflexiveLink(uri, "GET", "self");
        if (this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(uri, "DELETE", "delete");
        }
        if (this.isAuthorized((Permission)Permissions.UPDATE)) {
            dto.addReflexiveLink(uri, "PUT", "update");
        }
        return dto;
    }

    protected Authorization getDbAuthorization() {
        Authorization dbAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().authorizationId(this.resourceId).singleResult();
        if (dbAuthorization == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Authorization with id " + this.resourceId + " does not exist.");
        }
        return dbAuthorization;
    }
}

