/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.history.impl;

import io.openbpm.bpm.engine.AuthorizationException;
import io.openbpm.bpm.engine.HistoryService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.history.HistoricProcessInstance;
import io.openbpm.bpm.engine.rest.dto.history.HistoricProcessInstanceDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.sub.history.HistoricProcessInstanceResource;
import jakarta.ws.rs.core.Response;

public class HistoricProcessInstanceResourceImpl
implements HistoricProcessInstanceResource {
    private final ProcessEngine engine;
    private final String processInstanceId;

    public HistoricProcessInstanceResourceImpl(ProcessEngine engine, String processInstanceId) {
        this.engine = engine;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public HistoricProcessInstanceDto getHistoricProcessInstance() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricProcessInstance instance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic process instance with id " + this.processInstanceId + " does not exist");
        }
        return HistoricProcessInstanceDto.fromHistoricProcessInstance(instance);
    }

    @Override
    public void deleteHistoricProcessInstance(Boolean failIfNotExists) {
        HistoryService historyService = this.engine.getHistoryService();
        try {
            if (failIfNotExists == null || failIfNotExists.booleanValue()) {
                historyService.deleteHistoricProcessInstance(this.processInstanceId);
            } else {
                historyService.deleteHistoricProcessInstanceIfExists(this.processInstanceId);
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "Historic process instance with id " + this.processInstanceId + " does not exist");
        }
    }
}

