/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.xml.impl.instance;

import io.openbpm.bpm.model.xml.ModelException;
import io.openbpm.bpm.model.xml.impl.instance.DomElementImpl;
import io.openbpm.bpm.model.xml.impl.util.DomUtil;
import io.openbpm.bpm.model.xml.impl.util.XmlQName;
import io.openbpm.bpm.model.xml.instance.DomDocument;
import io.openbpm.bpm.model.xml.instance.DomElement;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DomDocumentImpl
implements DomDocument {
    public static final String GENERIC_NS_PREFIX = "ns";
    private final Document document;

    public DomDocumentImpl(Document document) {
        this.document = document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomElement getRootElement() {
        Document document = this.document;
        synchronized (document) {
            Element documentElement = this.document.getDocumentElement();
            if (documentElement != null) {
                return new DomElementImpl(documentElement);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRootElement(DomElement rootElement) {
        Document document = this.document;
        synchronized (document) {
            Element documentElement = this.document.getDocumentElement();
            Element newDocumentElement = ((DomElementImpl)rootElement).getElement();
            if (documentElement != null) {
                this.document.replaceChild(newDocumentElement, documentElement);
            } else {
                this.document.appendChild(newDocumentElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomElement createElement(String namespaceUri, String localName) {
        Document document = this.document;
        synchronized (document) {
            XmlQName xmlQName = new XmlQName(this, namespaceUri, localName);
            Element element = this.document.createElementNS(xmlQName.getNamespaceUri(), xmlQName.getPrefixedName());
            return new DomElementImpl(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomElement getElementById(String id) {
        Document document = this.document;
        synchronized (document) {
            Element element = this.document.getElementById(id);
            if (element != null) {
                return new DomElementImpl(element);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DomElement> getElementsByNameNs(String namespaceUri, String localName) {
        Document document = this.document;
        synchronized (document) {
            NodeList elementsByTagNameNS = this.document.getElementsByTagNameNS(namespaceUri, localName);
            return DomUtil.filterNodeListByName(elementsByTagNameNS, namespaceUri, localName);
        }
    }

    @Override
    public DOMSource getDomSource() {
        return new DOMSource(this.document);
    }

    @Override
    public String registerNamespace(String namespaceUri) {
        Document document = this.document;
        synchronized (document) {
            DomElement rootElement = this.getRootElement();
            if (rootElement != null) {
                return rootElement.registerNamespace(namespaceUri);
            }
            throw new ModelException("Unable to define a new namespace without a root document element");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNamespace(String prefix, String namespaceUri) {
        Document document = this.document;
        synchronized (document) {
            DomElement rootElement = this.getRootElement();
            if (rootElement == null) {
                throw new ModelException("Unable to define a new namespace without a root document element");
            }
            rootElement.registerNamespace(prefix, namespaceUri);
        }
    }

    protected String getUnusedGenericNsPrefix() {
        Document document = this.document;
        synchronized (document) {
            Element documentElement = this.document.getDocumentElement();
            if (documentElement == null) {
                return "ns0";
            }
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                if (documentElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", GENERIC_NS_PREFIX + i)) continue;
                return GENERIC_NS_PREFIX + i;
            }
            throw new ModelException("Unable to find an unused namespace prefix");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomDocument clone() {
        Document document = this.document;
        synchronized (document) {
            return new DomDocumentImpl((Document)this.document.cloneNode(true));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomDocumentImpl that = (DomDocumentImpl)o;
        return this.document.equals(that.document);
    }

    public int hashCode() {
        return this.document.hashCode();
    }
}

