/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.xml.impl.type.child;

import io.openbpm.bpm.model.xml.Model;
import io.openbpm.bpm.model.xml.ModelException;
import io.openbpm.bpm.model.xml.impl.ModelBuildOperation;
import io.openbpm.bpm.model.xml.impl.type.ModelElementTypeImpl;
import io.openbpm.bpm.model.xml.impl.type.child.ChildElementCollectionImpl;
import io.openbpm.bpm.model.xml.impl.type.reference.ElementReferenceCollectionBuilderImpl;
import io.openbpm.bpm.model.xml.impl.type.reference.IdsElementReferenceCollectionBuilderImpl;
import io.openbpm.bpm.model.xml.impl.type.reference.QNameElementReferenceCollectionBuilderImpl;
import io.openbpm.bpm.model.xml.impl.type.reference.UriElementReferenceCollectionBuilderImpl;
import io.openbpm.bpm.model.xml.instance.ModelElementInstance;
import io.openbpm.bpm.model.xml.type.ModelElementType;
import io.openbpm.bpm.model.xml.type.child.ChildElementCollection;
import io.openbpm.bpm.model.xml.type.child.ChildElementCollectionBuilder;
import io.openbpm.bpm.model.xml.type.reference.ElementReferenceCollectionBuilder;
import java.util.ArrayList;
import java.util.List;

public class ChildElementCollectionBuilderImpl<T extends ModelElementInstance>
implements ChildElementCollectionBuilder<T>,
ModelBuildOperation {
    protected final ModelElementTypeImpl parentElementType;
    private final ChildElementCollectionImpl<T> collection;
    protected final Class<T> childElementType;
    private ElementReferenceCollectionBuilder<?, ?> referenceBuilder;
    private final List<ModelBuildOperation> modelBuildOperations = new ArrayList<ModelBuildOperation>();

    public ChildElementCollectionBuilderImpl(Class<T> childElementTypeClass, ModelElementType parentElementType) {
        this.childElementType = childElementTypeClass;
        this.parentElementType = (ModelElementTypeImpl)parentElementType;
        this.collection = this.createCollectionInstance();
    }

    protected ChildElementCollectionImpl<T> createCollectionInstance() {
        return new ChildElementCollectionImpl<T>(this.childElementType, this.parentElementType);
    }

    @Override
    public ChildElementCollectionBuilder<T> immutable() {
        this.collection.setImmutable();
        return this;
    }

    @Override
    public ChildElementCollectionBuilder<T> required() {
        this.collection.setMinOccurs(1);
        return this;
    }

    @Override
    public ChildElementCollectionBuilder<T> maxOccurs(int i) {
        this.collection.setMaxOccurs(i);
        return this;
    }

    @Override
    public ChildElementCollectionBuilder<T> minOccurs(int i) {
        this.collection.setMinOccurs(i);
        return this;
    }

    @Override
    public ChildElementCollection<T> build() {
        return this.collection;
    }

    @Override
    public <V extends ModelElementInstance> ElementReferenceCollectionBuilder<V, T> qNameElementReferenceCollection(Class<V> referenceTargetType) {
        ChildElementCollectionImpl childElementCollection = (ChildElementCollectionImpl)this.build();
        QNameElementReferenceCollectionBuilderImpl<V, T> builder = new QNameElementReferenceCollectionBuilderImpl<V, T>(this.childElementType, referenceTargetType, childElementCollection);
        this.setReferenceBuilder(builder);
        return builder;
    }

    @Override
    public <V extends ModelElementInstance> ElementReferenceCollectionBuilder<V, T> idElementReferenceCollection(Class<V> referenceTargetType) {
        ChildElementCollectionImpl childElementCollection = (ChildElementCollectionImpl)this.build();
        ElementReferenceCollectionBuilderImpl<V, T> builder = new ElementReferenceCollectionBuilderImpl<V, T>(this.childElementType, referenceTargetType, childElementCollection);
        this.setReferenceBuilder(builder);
        return builder;
    }

    @Override
    public <V extends ModelElementInstance> ElementReferenceCollectionBuilder<V, T> idsElementReferenceCollection(Class<V> referenceTargetType) {
        ChildElementCollectionImpl childElementCollection = (ChildElementCollectionImpl)this.build();
        IdsElementReferenceCollectionBuilderImpl<V, T> builder = new IdsElementReferenceCollectionBuilderImpl<V, T>(this.childElementType, referenceTargetType, childElementCollection);
        this.setReferenceBuilder(builder);
        return builder;
    }

    @Override
    public <V extends ModelElementInstance> ElementReferenceCollectionBuilder<V, T> uriElementReferenceCollection(Class<V> referenceTargetType) {
        ChildElementCollectionImpl childElementCollection = (ChildElementCollectionImpl)this.build();
        UriElementReferenceCollectionBuilderImpl<V, T> builder = new UriElementReferenceCollectionBuilderImpl<V, T>(this.childElementType, referenceTargetType, childElementCollection);
        this.setReferenceBuilder(builder);
        return builder;
    }

    protected void setReferenceBuilder(ElementReferenceCollectionBuilder<?, ?> referenceBuilder) {
        if (this.referenceBuilder != null) {
            throw new ModelException("An collection cannot have more than one reference");
        }
        this.referenceBuilder = referenceBuilder;
        this.modelBuildOperations.add(referenceBuilder);
    }

    @Override
    public void performModelBuild(Model model) {
        ModelElementType elementType = model.getType(this.childElementType);
        if (elementType == null) {
            throw new ModelException(this.parentElementType + " declares undefined child element of type " + this.childElementType + ".");
        }
        this.parentElementType.registerChildElementType(elementType);
        this.parentElementType.registerChildElementCollection(this.collection);
        for (ModelBuildOperation modelBuildOperation : this.modelBuildOperations) {
            modelBuildOperation.performModelBuild(model);
        }
    }
}

