/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.xml.impl.type.reference;

import io.openbpm.bpm.model.xml.Model;
import io.openbpm.bpm.model.xml.ModelException;
import io.openbpm.bpm.model.xml.impl.type.ModelElementTypeImpl;
import io.openbpm.bpm.model.xml.impl.type.attribute.AttributeImpl;
import io.openbpm.bpm.model.xml.impl.type.child.ChildElementCollectionImpl;
import io.openbpm.bpm.model.xml.impl.type.reference.ElementReferenceCollectionImpl;
import io.openbpm.bpm.model.xml.instance.ModelElementInstance;
import io.openbpm.bpm.model.xml.type.reference.ElementReferenceCollection;
import io.openbpm.bpm.model.xml.type.reference.ElementReferenceCollectionBuilder;

public class ElementReferenceCollectionBuilderImpl<TARGET extends ModelElementInstance, SOURCE extends ModelElementInstance>
implements ElementReferenceCollectionBuilder<TARGET, SOURCE> {
    private final Class<SOURCE> childElementType;
    private final Class<TARGET> referenceTargetClass;
    protected ElementReferenceCollectionImpl<TARGET, SOURCE> elementReferenceCollectionImpl;

    public ElementReferenceCollectionBuilderImpl(Class<SOURCE> childElementType, Class<TARGET> referenceTargetClass, ChildElementCollectionImpl<SOURCE> collection) {
        this.childElementType = childElementType;
        this.referenceTargetClass = referenceTargetClass;
        this.elementReferenceCollectionImpl = new ElementReferenceCollectionImpl(collection);
    }

    @Override
    public ElementReferenceCollection<TARGET, SOURCE> build() {
        return this.elementReferenceCollectionImpl;
    }

    @Override
    public void performModelBuild(Model model) {
        ModelElementTypeImpl referenceTargetType = (ModelElementTypeImpl)model.getType(this.referenceTargetClass);
        ModelElementTypeImpl referenceSourceType = (ModelElementTypeImpl)model.getType(this.childElementType);
        this.elementReferenceCollectionImpl.setReferenceTargetElementType(referenceTargetType);
        this.elementReferenceCollectionImpl.setReferenceSourceElementType(referenceSourceType);
        AttributeImpl idAttribute = (AttributeImpl)referenceTargetType.getAttribute("id");
        if (idAttribute == null) {
            throw new ModelException("Unable to find id attribute of " + this.referenceTargetClass);
        }
        idAttribute.registerIncoming(this.elementReferenceCollectionImpl);
        this.elementReferenceCollectionImpl.setReferenceTargetAttribute(idAttribute);
    }
}

