/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.feel.impl.scala;

import camundajar.impl.scala.jdk.CollectionConverters;
import camundajar.impl.scala.runtime.BoxesRunTime;
import camundajar.impl.scala.util.Either;
import camundajar.impl.scala.util.Left;
import camundajar.impl.scala.util.Right;
import io.openbpm.bpm.dmn.feel.impl.FeelEngine;
import io.openbpm.bpm.dmn.feel.impl.scala.ContextVariableWrapper;
import io.openbpm.bpm.dmn.feel.impl.scala.ScalaFeelLogger;
import io.openbpm.bpm.dmn.feel.impl.scala.function.CustomFunctionTransformer;
import io.openbpm.bpm.dmn.feel.impl.scala.function.FeelCustomFunctionProvider;
import io.openbpm.bpm.dmn.feel.impl.scala.spin.SpinValueMapperFactory;
import io.openbpm.bpm.engine.variable.context.VariableContext;
import java.util.Arrays;
import java.util.List;
import org.camunda.feel.FeelEngine;
import org.camunda.feel.api.FeelEngineApi;
import org.camunda.feel.api.FeelEngineBuilder;
import org.camunda.feel.context.Context;
import org.camunda.feel.context.CustomContext;
import org.camunda.feel.context.FunctionProvider;
import org.camunda.feel.context.VariableProvider;
import org.camunda.feel.impl.JavaValueMapper;
import org.camunda.feel.valuemapper.CustomValueMapper;
import org.camunda.feel.valuemapper.ValueMapper;

public class ScalaFeelEngine
implements FeelEngine {
    protected static final ScalaFeelLogger LOGGER = ScalaFeelLogger.LOGGER;
    protected final FeelEngineApi feelEngineApi;

    public ScalaFeelEngine(List<FeelCustomFunctionProvider> functionProviders) {
        camundajar.impl.scala.collection.immutable.List<CustomValueMapper> valueMappers = this.getValueMappers();
        ValueMapper.CompositeValueMapper compositeValueMapper = new ValueMapper.CompositeValueMapper(valueMappers);
        CustomFunctionTransformer customFunctionTransformer = new CustomFunctionTransformer(functionProviders, (ValueMapper)compositeValueMapper);
        this.feelEngineApi = this.buildFeelEngineApi(customFunctionTransformer, compositeValueMapper);
    }

    public <T> T evaluateSimpleExpression(String expression, final VariableContext variableContext) {
        CustomContext context = new CustomContext(){

            public VariableProvider variableProvider() {
                return new ContextVariableWrapper(variableContext);
            }
        };
        Either either = this.feelEngineApi.evaluateExpression(expression, (Context)context).toEither();
        return this.handleEvaluationResult((Either<FeelEngine.Failure, Object>)either);
    }

    public boolean evaluateSimpleUnaryTests(String expression, String inputName, final VariableContext variableContext) {
        Object inputVariable = inputName != null && variableContext != null && variableContext.containsVariable(inputName) ? variableContext.resolve(inputName).getValue() : null;
        CustomContext context = new CustomContext(){

            public VariableProvider variableProvider() {
                return new VariableProvider.CompositeVariableProvider(ScalaFeelEngine.this.toScalaList(new ContextVariableWrapper(variableContext)));
            }
        };
        Either either = this.feelEngineApi.evaluateUnaryTests(expression, inputVariable, (Context)context).toEither();
        Object result = this.handleEvaluationResult((Either<FeelEngine.Failure, Object>)either);
        return BoxesRunTime.unboxToBoolean(result);
    }

    private <T> T handleEvaluationResult(Either<FeelEngine.Failure, Object> either) {
        if (either instanceof Right) {
            Right right = (Right)either;
            return (T)right.value();
        }
        Left left = (Left)either;
        FeelEngine.Failure failure = (FeelEngine.Failure)left.value();
        String message = failure.message();
        throw LOGGER.evaluationException(message);
    }

    protected camundajar.impl.scala.collection.immutable.List<CustomValueMapper> getValueMappers() {
        SpinValueMapperFactory spinValueMapperFactory = new SpinValueMapperFactory();
        JavaValueMapper javaValueMapper = new JavaValueMapper();
        CustomValueMapper spinValueMapper = spinValueMapperFactory.createInstance();
        if (spinValueMapper != null) {
            return this.toScalaList(javaValueMapper, spinValueMapper);
        }
        return this.toScalaList(javaValueMapper);
    }

    @SafeVarargs
    protected final <T> camundajar.impl.scala.collection.immutable.List<T> toScalaList(T ... elements) {
        List<T> listAsJava = Arrays.asList(elements);
        return this.toList(listAsJava);
    }

    protected <T> camundajar.impl.scala.collection.immutable.List<T> toList(List<T> list) {
        return CollectionConverters.ListHasAsScala(list).asScala().toList();
    }

    protected FeelEngineApi buildFeelEngineApi(CustomFunctionTransformer transformer, ValueMapper.CompositeValueMapper valueMapper) {
        return FeelEngineBuilder.forJava().withFunctionProvider((FunctionProvider)transformer).withValueMapper((ValueMapper)valueMapper).withEnabledExternalFunctions(false).build();
    }
}

