/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.engine.impl.el;

import io.openbpm.bpm.dmn.engine.impl.el.JuelElContextFactory;
import io.openbpm.bpm.dmn.engine.impl.el.JuelExpression;
import io.openbpm.bpm.dmn.engine.impl.el.VariableContextElResolver;
import io.openbpm.bpm.dmn.engine.impl.spi.el.ElExpression;
import io.openbpm.bpm.dmn.engine.impl.spi.el.ElProvider;
import io.openbpm.bpm.impl.juel.ExpressionFactoryImpl;
import io.openbpm.bpm.impl.juel.SimpleContext;
import io.openbpm.bpm.impl.juel.TreeValueExpression;
import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.ValueExpression;

public class JuelElProvider
implements ElProvider {
    protected final ExpressionFactoryImpl factory;
    protected final JuelElContextFactory elContextFactory;
    protected final ELContext parsingElContext;

    public JuelElProvider() {
        this(new ExpressionFactoryImpl(), new JuelElContextFactory(JuelElProvider.createDefaultResolver()));
    }

    public JuelElProvider(ExpressionFactoryImpl expressionFactory, JuelElContextFactory elContextFactory) {
        this.factory = expressionFactory;
        this.elContextFactory = elContextFactory;
        this.parsingElContext = this.createDefaultParsingElContext();
    }

    protected SimpleContext createDefaultParsingElContext() {
        return new SimpleContext();
    }

    @Override
    public ElExpression createExpression(String expression) {
        TreeValueExpression juelExpr = this.factory.createValueExpression(this.parsingElContext, expression, Object.class);
        return new JuelExpression((ValueExpression)juelExpr, this.elContextFactory);
    }

    public ExpressionFactoryImpl getFactory() {
        return this.factory;
    }

    public JuelElContextFactory getElContextFactory() {
        return this.elContextFactory;
    }

    public ELContext getParsingElContext() {
        return this.parsingElContext;
    }

    protected static ELResolver createDefaultResolver() {
        CompositeELResolver resolver = new CompositeELResolver();
        resolver.add((ELResolver)new VariableContextElResolver());
        resolver.add((ELResolver)new ArrayELResolver(true));
        resolver.add((ELResolver)new ListELResolver(true));
        resolver.add((ELResolver)new MapELResolver(true));
        resolver.add((ELResolver)new ResourceBundleELResolver());
        resolver.add((ELResolver)new BeanELResolver());
        return resolver;
    }
}

