/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.engine.impl.transform;

import io.openbpm.bpm.dmn.engine.DmnDecision;
import io.openbpm.bpm.dmn.engine.DmnDecisionRequirementsGraph;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionLiteralExpressionImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionRequirementsGraphImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionTableImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionTableInputImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionTableOutputImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionTableRuleImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnExpressionImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnLogger;
import io.openbpm.bpm.dmn.engine.impl.DmnVariableImpl;
import io.openbpm.bpm.dmn.engine.impl.spi.hitpolicy.DmnHitPolicyHandlerRegistry;
import io.openbpm.bpm.dmn.engine.impl.spi.transform.DmnElementTransformContext;
import io.openbpm.bpm.dmn.engine.impl.spi.transform.DmnElementTransformHandler;
import io.openbpm.bpm.dmn.engine.impl.spi.transform.DmnElementTransformHandlerRegistry;
import io.openbpm.bpm.dmn.engine.impl.spi.transform.DmnTransform;
import io.openbpm.bpm.dmn.engine.impl.spi.transform.DmnTransformListener;
import io.openbpm.bpm.dmn.engine.impl.spi.transform.DmnTransformer;
import io.openbpm.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformerRegistry;
import io.openbpm.bpm.dmn.engine.impl.transform.DmnTransformLogger;
import io.openbpm.bpm.model.dmn.Dmn;
import io.openbpm.bpm.model.dmn.DmnModelException;
import io.openbpm.bpm.model.dmn.DmnModelInstance;
import io.openbpm.bpm.model.dmn.instance.Decision;
import io.openbpm.bpm.model.dmn.instance.DecisionTable;
import io.openbpm.bpm.model.dmn.instance.Definitions;
import io.openbpm.bpm.model.dmn.instance.Expression;
import io.openbpm.bpm.model.dmn.instance.InformationRequirement;
import io.openbpm.bpm.model.dmn.instance.Input;
import io.openbpm.bpm.model.dmn.instance.InputEntry;
import io.openbpm.bpm.model.dmn.instance.InputExpression;
import io.openbpm.bpm.model.dmn.instance.LiteralExpression;
import io.openbpm.bpm.model.dmn.instance.Output;
import io.openbpm.bpm.model.dmn.instance.OutputEntry;
import io.openbpm.bpm.model.dmn.instance.Rule;
import io.openbpm.bpm.model.dmn.instance.Variable;
import io.openbpm.commons.utils.EnsureUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DefaultDmnTransform
implements DmnTransform,
DmnElementTransformContext {
    private static final DmnTransformLogger LOG = DmnLogger.TRANSFORM_LOGGER;
    protected DmnTransformer transformer;
    protected List<DmnTransformListener> transformListeners;
    protected DmnElementTransformHandlerRegistry handlerRegistry;
    protected DmnModelInstance modelInstance;
    protected Object parent;
    protected DmnDecisionImpl decision;
    protected DmnDecisionTableImpl decisionTable;
    protected DmnDataTypeTransformerRegistry dataTypeTransformerRegistry;
    protected DmnHitPolicyHandlerRegistry hitPolicyHandlerRegistry;

    public DefaultDmnTransform(DmnTransformer transformer) {
        this.transformer = transformer;
        this.transformListeners = transformer.getTransformListeners();
        this.handlerRegistry = transformer.getElementTransformHandlerRegistry();
        this.dataTypeTransformerRegistry = transformer.getDataTypeTransformerRegistry();
        this.hitPolicyHandlerRegistry = transformer.getHitPolicyHandlerRegistry();
    }

    @Override
    public void setModelInstance(File file) {
        EnsureUtil.ensureNotNull((String)"file", (Object)file);
        try {
            this.modelInstance = Dmn.readModelFromFile((File)file);
        }
        catch (DmnModelException e) {
            throw LOG.unableToTransformDecisionsFromFile(file, e);
        }
    }

    @Override
    public DmnTransform modelInstance(File file) {
        this.setModelInstance(file);
        return this;
    }

    @Override
    public void setModelInstance(InputStream inputStream) {
        EnsureUtil.ensureNotNull((String)"inputStream", (Object)inputStream);
        try {
            this.modelInstance = Dmn.readModelFromStream((InputStream)inputStream);
        }
        catch (DmnModelException e) {
            throw LOG.unableToTransformDecisionsFromInputStream(e);
        }
    }

    @Override
    public DmnTransform modelInstance(InputStream inputStream) {
        this.setModelInstance(inputStream);
        return this;
    }

    @Override
    public void setModelInstance(DmnModelInstance modelInstance) {
        EnsureUtil.ensureNotNull((String)"dmnModelInstance", (Object)modelInstance);
        this.modelInstance = modelInstance;
    }

    @Override
    public DmnTransform modelInstance(DmnModelInstance modelInstance) {
        this.setModelInstance(modelInstance);
        return this;
    }

    @Override
    public <T extends DmnDecisionRequirementsGraph> T transformDecisionRequirementsGraph() {
        try {
            Definitions definitions = this.modelInstance.getDefinitions();
            return (T)this.transformDefinitions(definitions);
        }
        catch (Exception e) {
            throw LOG.errorWhileTransformingDefinitions(e);
        }
    }

    protected DmnDecisionRequirementsGraph transformDefinitions(Definitions definitions) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(Definitions.class);
        DmnDecisionRequirementsGraphImpl dmnDrg = (DmnDecisionRequirementsGraphImpl)handler.handleElement(this, definitions);
        if (dmnDrg.getKey() == null) {
            throw LOG.drdIdIsMissing(dmnDrg);
        }
        Collection decisions = definitions.getChildElementsByType(Decision.class);
        List<DmnDecision> dmnDecisions = this.transformDecisions(decisions);
        for (DmnDecision dmnDecision : dmnDecisions) {
            dmnDrg.addDecision(dmnDecision);
        }
        this.notifyTransformListeners(definitions, dmnDrg);
        return dmnDrg;
    }

    @Override
    public <T extends DmnDecision> List<T> transformDecisions() {
        try {
            Definitions definitions = this.modelInstance.getDefinitions();
            Collection decisions = definitions.getChildElementsByType(Decision.class);
            return this.transformDecisions(decisions);
        }
        catch (Exception e) {
            throw LOG.errorWhileTransformingDecisions(e);
        }
    }

    protected List<DmnDecision> transformDecisions(Collection<Decision> decisions) {
        Map<String, DmnDecisionImpl> dmnDecisions = this.transformIndividualDecisions(decisions);
        this.buildDecisionRequirements(decisions, dmnDecisions);
        ArrayList<DmnDecision> dmnDecisionList = new ArrayList<DmnDecision>(dmnDecisions.values());
        for (Decision dec : decisions) {
            DmnDecision dmnDecision = dmnDecisions.get(dec.getId());
            this.notifyTransformListeners(dec, dmnDecision);
        }
        this.ensureNoLoopInDecisions(dmnDecisionList);
        return dmnDecisionList;
    }

    protected Map<String, DmnDecisionImpl> transformIndividualDecisions(Collection<Decision> decisions) {
        HashMap<String, DmnDecisionImpl> dmnDecisions = new HashMap<String, DmnDecisionImpl>();
        for (Decision dec : decisions) {
            DmnDecisionImpl dmnDecision = this.transformDecision(dec);
            if (dmnDecision == null) continue;
            dmnDecisions.put(dmnDecision.getKey(), dmnDecision);
        }
        return dmnDecisions;
    }

    protected void buildDecisionRequirements(Collection<Decision> decisions, Map<String, DmnDecisionImpl> dmnDecisions) {
        for (Decision dec : decisions) {
            List<DmnDecision> requiredDmnDecisions = this.getRequiredDmnDecisions(dec, dmnDecisions);
            DmnDecisionImpl dmnDecision = dmnDecisions.get(dec.getId());
            if (requiredDmnDecisions.isEmpty()) continue;
            dmnDecision.setRequiredDecision(requiredDmnDecisions);
        }
    }

    protected void ensureNoLoopInDecisions(List<DmnDecision> dmnDecisionList) {
        ArrayList<String> visitedDecisions = new ArrayList<String>();
        for (DmnDecision dec : dmnDecisionList) {
            this.ensureNoLoopInDecision(dec, new ArrayList<String>(), visitedDecisions);
        }
    }

    protected void ensureNoLoopInDecision(DmnDecision decision, List<String> parentDecisionList, List<String> visitedDecisions) {
        if (visitedDecisions.contains(decision.getKey())) {
            return;
        }
        parentDecisionList.add(decision.getKey());
        for (DmnDecision requiredDecision : decision.getRequiredDecisions()) {
            if (parentDecisionList.contains(requiredDecision.getKey())) {
                throw LOG.requiredDecisionLoopDetected(requiredDecision.getKey());
            }
            this.ensureNoLoopInDecision(requiredDecision, new ArrayList<String>(parentDecisionList), visitedDecisions);
        }
        visitedDecisions.add(decision.getKey());
    }

    protected List<DmnDecision> getRequiredDmnDecisions(Decision decision, Map<String, DmnDecisionImpl> dmnDecisions) {
        ArrayList<DmnDecision> requiredDecisionList = new ArrayList<DmnDecision>();
        for (InformationRequirement informationRequirement : decision.getInformationRequirements()) {
            Decision requiredDecision = informationRequirement.getRequiredDecision();
            if (requiredDecision == null) continue;
            DmnDecision requiredDmnDecision = dmnDecisions.get(requiredDecision.getId());
            requiredDecisionList.add(requiredDmnDecision);
        }
        return requiredDecisionList;
    }

    protected DmnDecisionImpl transformDecision(Decision decision) {
        DmnDecisionImpl dmnDecision;
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(Decision.class);
        this.decision = dmnDecision = (DmnDecisionImpl)handler.handleElement(this, decision);
        if (dmnDecision.getKey() == null) {
            throw LOG.decisionIdIsMissing(dmnDecision);
        }
        Expression expression = decision.getExpression();
        if (expression == null) {
            LOG.decisionWithoutExpression(decision);
            return null;
        }
        if (expression instanceof DecisionTable) {
            DecisionTable decisionTbl = (DecisionTable)expression;
            DmnDecisionTableImpl dmnDecisionTable = this.transformDecisionTable(decisionTbl);
            dmnDecision.setDecisionLogic(dmnDecisionTable);
        } else if (expression instanceof LiteralExpression) {
            LiteralExpression literalExpression = (LiteralExpression)expression;
            DmnDecisionLiteralExpressionImpl dmnDecisionLiteralExpression = this.transformDecisionLiteralExpression(decision, literalExpression);
            dmnDecision.setDecisionLogic(dmnDecisionLiteralExpression);
        } else {
            LOG.decisionTypeNotSupported(expression, decision);
            return null;
        }
        return dmnDecision;
    }

    protected DmnDecisionTableImpl transformDecisionTable(DecisionTable decisionTable) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(DecisionTable.class);
        DmnDecisionTableImpl dmnDecisionTable = (DmnDecisionTableImpl)handler.handleElement(this, decisionTable);
        for (Input input : decisionTable.getInputs()) {
            this.parent = dmnDecisionTable;
            this.decisionTable = dmnDecisionTable;
            DmnDecisionTableInputImpl dmnInput = this.transformDecisionTableInput(input);
            if (dmnInput == null) continue;
            dmnDecisionTable.getInputs().add(dmnInput);
            this.notifyTransformListeners(input, dmnInput);
        }
        boolean needsName = decisionTable.getOutputs().size() > 1;
        HashSet<String> usedNames = new HashSet<String>();
        for (Output output : decisionTable.getOutputs()) {
            this.parent = dmnDecisionTable;
            this.decisionTable = dmnDecisionTable;
            DmnDecisionTableOutputImpl dmnOutput = this.transformDecisionTableOutput(output);
            if (dmnOutput == null) continue;
            String outputName = dmnOutput.getOutputName();
            if (needsName && outputName == null) {
                throw LOG.compoundOutputsShouldHaveAnOutputName(dmnDecisionTable, dmnOutput);
            }
            if (usedNames.contains(outputName)) {
                throw LOG.compoundOutputWithDuplicateName(dmnDecisionTable, dmnOutput);
            }
            usedNames.add(outputName);
            dmnDecisionTable.getOutputs().add(dmnOutput);
            this.notifyTransformListeners(output, dmnOutput);
        }
        for (Rule rule : decisionTable.getRules()) {
            this.parent = dmnDecisionTable;
            this.decisionTable = dmnDecisionTable;
            DmnDecisionTableRuleImpl dmnRule = this.transformDecisionTableRule(rule);
            if (dmnRule == null) continue;
            dmnDecisionTable.getRules().add(dmnRule);
            this.notifyTransformListeners(rule, dmnRule);
        }
        return dmnDecisionTable;
    }

    protected DmnDecisionTableInputImpl transformDecisionTableInput(Input input) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(Input.class);
        DmnDecisionTableInputImpl dmnInput = (DmnDecisionTableInputImpl)handler.handleElement(this, input);
        if (dmnInput.getId() == null) {
            throw LOG.decisionTableInputIdIsMissing(this.decision, dmnInput);
        }
        InputExpression inputExpression = input.getInputExpression();
        if (inputExpression != null) {
            this.parent = dmnInput;
            DmnExpressionImpl dmnExpression = this.transformInputExpression(inputExpression);
            if (dmnExpression != null) {
                dmnInput.setExpression(dmnExpression);
            }
        }
        return dmnInput;
    }

    protected DmnDecisionTableOutputImpl transformDecisionTableOutput(Output output) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(Output.class);
        DmnDecisionTableOutputImpl dmnOutput = (DmnDecisionTableOutputImpl)handler.handleElement(this, output);
        if (dmnOutput.getId() == null) {
            throw LOG.decisionTableOutputIdIsMissing(this.decision, dmnOutput);
        }
        return dmnOutput;
    }

    protected DmnDecisionTableRuleImpl transformDecisionTableRule(Rule rule) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(Rule.class);
        DmnDecisionTableRuleImpl dmnRule = (DmnDecisionTableRuleImpl)handler.handleElement(this, rule);
        if (dmnRule.getId() == null) {
            throw LOG.decisionTableRuleIdIsMissing(this.decision, dmnRule);
        }
        List<DmnDecisionTableInputImpl> inputs = this.decisionTable.getInputs();
        ArrayList inputEntries = new ArrayList(rule.getInputEntries());
        if (inputs.size() != inputEntries.size()) {
            throw LOG.differentNumberOfInputsAndInputEntries(inputs.size(), inputEntries.size(), dmnRule);
        }
        for (InputEntry inputEntry : inputEntries) {
            this.parent = dmnRule;
            DmnExpressionImpl condition = this.transformInputEntry(inputEntry);
            dmnRule.getConditions().add(condition);
        }
        List<DmnDecisionTableOutputImpl> outputs = this.decisionTable.getOutputs();
        ArrayList outputEntries = new ArrayList(rule.getOutputEntries());
        if (outputs.size() != outputEntries.size()) {
            throw LOG.differentNumberOfOutputsAndOutputEntries(outputs.size(), outputEntries.size(), dmnRule);
        }
        for (OutputEntry outputEntry : outputEntries) {
            this.parent = dmnRule;
            DmnExpressionImpl conclusion = this.transformOutputEntry(outputEntry);
            dmnRule.getConclusions().add(conclusion);
        }
        return dmnRule;
    }

    protected DmnExpressionImpl transformInputExpression(InputExpression inputExpression) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(InputExpression.class);
        return (DmnExpressionImpl)handler.handleElement(this, inputExpression);
    }

    protected DmnExpressionImpl transformInputEntry(InputEntry inputEntry) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(InputEntry.class);
        return (DmnExpressionImpl)handler.handleElement(this, inputEntry);
    }

    protected DmnExpressionImpl transformOutputEntry(OutputEntry outputEntry) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(OutputEntry.class);
        return (DmnExpressionImpl)handler.handleElement(this, outputEntry);
    }

    protected DmnDecisionLiteralExpressionImpl transformDecisionLiteralExpression(Decision decision, LiteralExpression literalExpression) {
        DmnDecisionLiteralExpressionImpl dmnDecisionLiteralExpression = new DmnDecisionLiteralExpressionImpl();
        Variable variable = decision.getVariable();
        if (variable == null) {
            throw LOG.decisionVariableIsMissing(decision.getId());
        }
        DmnVariableImpl dmnVariable = this.transformVariable(variable);
        dmnDecisionLiteralExpression.setVariable(dmnVariable);
        DmnExpressionImpl dmnLiteralExpression = this.transformLiteralExpression(literalExpression);
        dmnDecisionLiteralExpression.setExpression(dmnLiteralExpression);
        return dmnDecisionLiteralExpression;
    }

    protected DmnExpressionImpl transformLiteralExpression(LiteralExpression literalExpression) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(LiteralExpression.class);
        return (DmnExpressionImpl)handler.handleElement(this, literalExpression);
    }

    protected DmnVariableImpl transformVariable(Variable variable) {
        DmnElementTransformHandler handler = this.handlerRegistry.getHandler(Variable.class);
        return (DmnVariableImpl)handler.handleElement(this, variable);
    }

    protected void notifyTransformListeners(Decision decision, DmnDecision dmnDecision) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformDecision(decision, dmnDecision);
        }
    }

    protected void notifyTransformListeners(Input input, DmnDecisionTableInputImpl dmnInput) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformDecisionTableInput(input, dmnInput);
        }
    }

    protected void notifyTransformListeners(Definitions definitions, DmnDecisionRequirementsGraphImpl dmnDecisionRequirementsGraph) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformDecisionRequirementsGraph(definitions, dmnDecisionRequirementsGraph);
        }
    }

    protected void notifyTransformListeners(Output output, DmnDecisionTableOutputImpl dmnOutput) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformDecisionTableOutput(output, dmnOutput);
        }
    }

    protected void notifyTransformListeners(Rule rule, DmnDecisionTableRuleImpl dmnRule) {
        for (DmnTransformListener transformListener : this.transformListeners) {
            transformListener.transformDecisionTableRule(rule, dmnRule);
        }
    }

    @Override
    public DmnModelInstance getModelInstance() {
        return this.modelInstance;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public DmnDecision getDecision() {
        return this.decision;
    }

    @Override
    public DmnDataTypeTransformerRegistry getDataTypeTransformerRegistry() {
        return this.dataTypeTransformerRegistry;
    }

    @Override
    public DmnHitPolicyHandlerRegistry getHitPolicyHandlerRegistry() {
        return this.hitPolicyHandlerRegistry;
    }
}

