/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.engine.impl.transform;

import io.openbpm.bpm.dmn.engine.impl.DmnDecisionTableImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnLogger;
import io.openbpm.bpm.dmn.engine.impl.spi.hitpolicy.DmnHitPolicyHandler;
import io.openbpm.bpm.dmn.engine.impl.spi.transform.DmnElementTransformContext;
import io.openbpm.bpm.dmn.engine.impl.spi.transform.DmnElementTransformHandler;
import io.openbpm.bpm.dmn.engine.impl.transform.DmnTransformLogger;
import io.openbpm.bpm.model.dmn.BuiltinAggregator;
import io.openbpm.bpm.model.dmn.HitPolicy;
import io.openbpm.bpm.model.dmn.instance.DecisionTable;

public class DmnDecisionTableTransformHandler
implements DmnElementTransformHandler<DecisionTable, DmnDecisionTableImpl> {
    protected static final DmnTransformLogger LOG = DmnLogger.TRANSFORM_LOGGER;

    @Override
    public DmnDecisionTableImpl handleElement(DmnElementTransformContext context, DecisionTable decisionTable) {
        return this.createFromDecisionTable(context, decisionTable);
    }

    protected DmnDecisionTableImpl createFromDecisionTable(DmnElementTransformContext context, DecisionTable decisionTable) {
        DmnDecisionTableImpl dmnDecisionTable = this.createDmnElement(context, decisionTable);
        dmnDecisionTable.setHitPolicyHandler(this.getHitPolicyHandler(context, decisionTable, dmnDecisionTable));
        return dmnDecisionTable;
    }

    protected DmnDecisionTableImpl createDmnElement(DmnElementTransformContext context, DecisionTable decisionTable) {
        return new DmnDecisionTableImpl();
    }

    protected DmnHitPolicyHandler getHitPolicyHandler(DmnElementTransformContext context, DecisionTable decisionTable, DmnDecisionTableImpl dmnDecisionTable) {
        HitPolicy hitPolicy = decisionTable.getHitPolicy();
        if (hitPolicy == null) {
            hitPolicy = HitPolicy.UNIQUE;
        }
        BuiltinAggregator aggregation = decisionTable.getAggregation();
        DmnHitPolicyHandler hitPolicyHandler = context.getHitPolicyHandlerRegistry().getHandler(hitPolicy, aggregation);
        if (hitPolicyHandler != null) {
            return hitPolicyHandler;
        }
        throw LOG.hitPolicyNotSupported(dmnDecisionTable, hitPolicy, aggregation);
    }
}

