/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.engine.impl.type;

import io.openbpm.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformer;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.value.TypedValue;

public class IntegerDataTypeTransformer
implements DmnDataTypeTransformer {
    @Override
    public TypedValue transform(Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            int intValue = this.transformNumber(numberValue);
            return Variables.integerValue((Integer)intValue);
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            int intValue = this.transformString(stringValue);
            return Variables.integerValue((Integer)intValue);
        }
        throw new IllegalArgumentException();
    }

    protected int transformNumber(Number value) {
        if (this.isInteger(value)) {
            return value.intValue();
        }
        throw new IllegalArgumentException();
    }

    protected boolean isInteger(Number value) {
        double doubleValue = value.doubleValue();
        return doubleValue == (double)((int)doubleValue);
    }

    protected int transformString(String value) {
        return Integer.parseInt(value);
    }
}

