/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.engine.impl.type;

import io.openbpm.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformer;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.value.TypedValue;

public class LongDataTypeTransformer
implements DmnDataTypeTransformer {
    @Override
    public TypedValue transform(Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            long longValue = this.transformNumber(numberValue);
            return Variables.longValue((Long)longValue);
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            long longValue = this.transformString(stringValue);
            return Variables.longValue((Long)longValue);
        }
        throw new IllegalArgumentException();
    }

    protected long transformNumber(Number value) {
        if (this.isLong(value)) {
            return value.longValue();
        }
        throw new IllegalArgumentException();
    }

    protected boolean isLong(Number value) {
        double doubleValue = value.doubleValue();
        return doubleValue == (double)((long)doubleValue);
    }

    protected long transformString(String value) {
        return Long.parseLong(value);
    }
}

