/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.feel.impl.juel;

import io.openbpm.bpm.dmn.feel.impl.FeelEngine;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelConvertException;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelLogger;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelMethodInvocationException;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelMissingFunctionException;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelMissingVariableException;
import io.openbpm.bpm.dmn.feel.impl.juel.TransformExpressionCacheKey;
import io.openbpm.bpm.dmn.feel.impl.juel.el.ElContextFactory;
import io.openbpm.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import io.openbpm.bpm.engine.variable.context.VariableContext;
import io.openbpm.commons.utils.cache.Cache;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;

public class FeelEngineImpl
implements FeelEngine {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    protected FeelToJuelTransform transform;
    protected ExpressionFactory expressionFactory;
    protected ElContextFactory elContextFactory;
    protected Cache<TransformExpressionCacheKey, String> transformExpressionCache;

    public FeelEngineImpl(FeelToJuelTransform transform, ExpressionFactory expressionFactory, ElContextFactory elContextFactory, Cache<TransformExpressionCacheKey, String> transformExpressionCache) {
        this.transform = transform;
        this.expressionFactory = expressionFactory;
        this.elContextFactory = elContextFactory;
        this.transformExpressionCache = transformExpressionCache;
    }

    public <T> T evaluateSimpleExpression(String simpleExpression, VariableContext variableContext) {
        throw LOG.simpleExpressionNotSupported();
    }

    public boolean evaluateSimpleUnaryTests(String simpleUnaryTests, String inputName, VariableContext variableContext) {
        try {
            ELContext elContext = this.createContext(variableContext);
            ValueExpression valueExpression = this.transformSimpleUnaryTests(simpleUnaryTests, inputName, elContext);
            return (Boolean)valueExpression.getValue(elContext);
        }
        catch (FeelMissingFunctionException e) {
            throw LOG.unknownFunction(simpleUnaryTests, e);
        }
        catch (FeelMissingVariableException e) {
            if (inputName.equals(e.getVariable())) {
                throw LOG.unableToEvaluateExpressionAsNotInputIsSet(simpleUnaryTests, e);
            }
            throw LOG.unknownVariable(simpleUnaryTests, e);
        }
        catch (FeelConvertException e) {
            throw LOG.unableToConvertValue(simpleUnaryTests, e);
        }
        catch (ELException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof FeelMethodInvocationException) {
                FeelMethodInvocationException feelMethodInvocationException = (FeelMethodInvocationException)((Object)throwable);
                throw LOG.unableToInvokeMethod(simpleUnaryTests, feelMethodInvocationException);
            }
            throw LOG.unableToEvaluateExpression(simpleUnaryTests, e);
        }
    }

    protected ELContext createContext(VariableContext variableContext) {
        return this.elContextFactory.createContext(this.expressionFactory, variableContext);
    }

    protected ValueExpression transformSimpleUnaryTests(String simpleUnaryTests, String inputName, ELContext elContext) {
        String juelExpression = this.transformToJuelExpression(simpleUnaryTests, inputName);
        try {
            return this.expressionFactory.createValueExpression(elContext, juelExpression, Object.class);
        }
        catch (ELException e) {
            throw LOG.invalidExpression(simpleUnaryTests, e);
        }
    }

    protected String transformToJuelExpression(String simpleUnaryTests, String inputName) {
        TransformExpressionCacheKey cacheKey = new TransformExpressionCacheKey(simpleUnaryTests, inputName);
        String juelExpression = (String)this.transformExpressionCache.get((Object)cacheKey);
        if (juelExpression == null) {
            juelExpression = this.transform.transformSimpleUnaryTests(simpleUnaryTests, inputName);
            this.transformExpressionCache.put((Object)cacheKey, (Object)juelExpression);
        }
        return juelExpression;
    }
}

