/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.feel.impl.juel.transform;

import io.openbpm.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelLogger;
import io.openbpm.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import io.openbpm.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransformer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComparisonTransformer
implements FeelToJuelTransformer {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    public static final Pattern COMPARISON_PATTERN = Pattern.compile("^(<=|>=|<|>)([^=].*)$");

    @Override
    public boolean canTransform(String feelExpression) {
        return feelExpression.startsWith("<=") || feelExpression.startsWith("<") || feelExpression.startsWith(">=") || feelExpression.startsWith(">");
    }

    @Override
    public String transform(FeelToJuelTransform transform, String feelExpression, String inputName) {
        Matcher matcher = COMPARISON_PATTERN.matcher(feelExpression);
        if (matcher.matches()) {
            return this.transformComparison(transform, matcher.group(1), matcher.group(2), inputName);
        }
        throw LOG.invalidComparisonExpression(feelExpression);
    }

    protected String transformComparison(FeelToJuelTransform transform, String operator, String endpoint, String inputName) {
        String juelEndpoint = transform.transformEndpoint(endpoint, inputName);
        return "%s %s %s".formatted(inputName, operator, juelEndpoint);
    }
}

