/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.feel.impl.juel.transform;

import io.openbpm.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelLogger;
import io.openbpm.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import io.openbpm.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransformer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IntervalTransformer
implements FeelToJuelTransformer {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    public static final Pattern INTERVAL_PATTERN = Pattern.compile("^(\\(|\\[|\\])(.*[^\\.])\\.\\.(.+)(\\)|\\]|\\[)$");

    @Override
    public boolean canTransform(String feelExpression) {
        return feelExpression.startsWith("(") || feelExpression.startsWith("[") || feelExpression.startsWith("]");
    }

    @Override
    public String transform(FeelToJuelTransform transform, String feelExpression, String inputName) {
        Matcher matcher = INTERVAL_PATTERN.matcher(feelExpression);
        if (matcher.matches()) {
            return this.transformInterval(transform, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), inputName);
        }
        throw LOG.invalidIntervalExpression(feelExpression);
    }

    public String transformInterval(FeelToJuelTransform transform, String startIntervalSymbol, String lowerEndpoint, String upperEndpoint, String stopIntervalSymbol, String inputName) {
        String juelLowerEndpoint = transform.transformEndpoint(lowerEndpoint, inputName);
        String juelUpperEndpoint = transform.transformEndpoint(upperEndpoint, inputName);
        String lowerEndpointComparator = this.transformLowerEndpointComparator(startIntervalSymbol);
        String upperEndpointComparator = this.transformUpperEndpointComparator(stopIntervalSymbol);
        return "%s %s %s && %s %s %s".formatted(inputName, lowerEndpointComparator, juelLowerEndpoint, inputName, upperEndpointComparator, juelUpperEndpoint);
    }

    protected String transformLowerEndpointComparator(String startIntervalSymbol) {
        if ("[".equals(startIntervalSymbol)) {
            return ">=";
        }
        return ">";
    }

    protected String transformUpperEndpointComparator(String stopIntervalSymbol) {
        if ("]".equals(stopIntervalSymbol)) {
            return "<=";
        }
        return "<";
    }
}

