/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.impl.util;

import io.openbpm.spin.impl.logging.SpinCoreLogger;
import io.openbpm.spin.impl.logging.SpinLogger;
import io.openbpm.spin.spi.DataFormat;

public final class SpinReflectUtil {
    private static final SpinCoreLogger LOG = SpinLogger.CORE_LOGGER;

    private SpinReflectUtil() {
    }

    public static Class<?> loadClass(String classname, DataFormat<?> dataFormat) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            LOG.tryLoadingClass(classname, cl);
            try {
                return cl.loadClass(classname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        cl = dataFormat.getClass().getClassLoader();
        try {
            LOG.tryLoadingClass(classname, cl);
            return cl.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw LOG.classNotFound(classname, e);
        }
    }
}

