/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.scripting;

import io.openbpm.commons.utils.IoUtil;
import io.openbpm.spin.SpinScriptException;
import io.openbpm.spin.impl.logging.SpinCoreLogger;
import io.openbpm.spin.impl.logging.SpinLogger;
import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class SpinScriptEnv {
    private static final SpinCoreLogger LOG = SpinLogger.CORE_LOGGER;
    private static final String ENV_PATH_TEMPLATE = "script/env/%s/spin.%s";
    public static final Map<String, String> extensions = new HashMap<String, String>();

    private SpinScriptEnv() {
    }

    public static String getExtension(String language) {
        if ("ecmascript".equals(language = language.toLowerCase())) {
            language = "javascript";
        }
        return extensions.get(language);
    }

    public static String get(String language) {
        String extension;
        if ("ecmascript".equals(language = language.toLowerCase())) {
            language = "javascript";
        }
        if ((extension = extensions.get(language)) == null) {
            return null;
        }
        return SpinScriptEnv.loadScriptEnv(language, extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String loadScriptEnv(String language, String extension) {
        String scriptEnvPath = ENV_PATH_TEMPLATE.formatted(language, extension);
        InputStream envResource = SpinScriptException.class.getClassLoader().getResourceAsStream(scriptEnvPath);
        if (envResource == null) {
            throw LOG.noScriptEnvFoundForLanguage(language, scriptEnvPath);
        }
        try {
            String string = IoUtil.inputStreamAsString((InputStream)envResource);
            return string;
        }
        finally {
            IoUtil.closeSilently((Closeable)envResource);
        }
    }

    static {
        extensions.put("python", "py");
        extensions.put("javascript", "js");
        extensions.put("groovy", "groovy");
        extensions.put("ruby", "rb");
    }
}

