/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.client5.http.entity;

import connectjar.org.apache.hc.client5.http.entity.InputStreamFactory;
import connectjar.org.apache.hc.core5.io.Closer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

class LazyDecompressingInputStream
extends FilterInputStream {
    private final InputStreamFactory inputStreamFactory;
    private InputStream wrapperStream;

    public LazyDecompressingInputStream(InputStream wrappedStream, InputStreamFactory inputStreamFactory) {
        super(wrappedStream);
        this.inputStreamFactory = inputStreamFactory;
    }

    private InputStream initWrapper() throws IOException {
        if (this.wrapperStream == null) {
            this.wrapperStream = this.inputStreamFactory.create(this.in);
        }
        return this.wrapperStream;
    }

    @Override
    public int read() throws IOException {
        return this.initWrapper().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.initWrapper().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.initWrapper().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.initWrapper().skip(n);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        return this.initWrapper().available();
    }

    @Override
    public void close() throws IOException {
        try {
            Closer.close(this.wrapperStream);
        }
        finally {
            super.close();
        }
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.initWrapper().mark(readlimit);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void reset() throws IOException {
        this.initWrapper().reset();
    }
}

