/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.client5.http.impl;

import connectjar.org.apache.hc.core5.annotation.Internal;
import connectjar.org.apache.hc.core5.http.HttpRequest;
import connectjar.org.apache.hc.core5.net.PercentCodec;
import connectjar.org.apache.hc.core5.net.URIBuilder;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;

@Internal
public final class RequestSupport {
    public static String extractPathPrefix(HttpRequest request) {
        String path = request.getPath();
        try {
            URIBuilder uriBuilder = new URIBuilder(path);
            uriBuilder.setFragment(null);
            uriBuilder.clearParameters();
            uriBuilder.optimize();
            List<String> pathSegments = uriBuilder.getPathSegments();
            if (!pathSegments.isEmpty()) {
                pathSegments.remove(pathSegments.size() - 1);
            }
            if (pathSegments.isEmpty()) {
                return "/";
            }
            StringBuilder buf = new StringBuilder();
            buf.append('/');
            for (String pathSegment : pathSegments) {
                PercentCodec.encode(buf, pathSegment, StandardCharsets.US_ASCII);
                buf.append('/');
            }
            return buf.toString();
        }
        catch (URISyntaxException ex) {
            return path;
        }
    }
}

