/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.client5.http.impl.async;

import connectjar.org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import connectjar.org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import connectjar.org.apache.hc.core5.concurrent.FutureCallback;
import connectjar.org.apache.hc.core5.function.Supplier;
import connectjar.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import connectjar.org.apache.hc.core5.io.CloseMode;
import connectjar.org.apache.hc.core5.net.NamedEndpoint;
import connectjar.org.apache.hc.core5.reactor.ConnectionInitiator;
import connectjar.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import connectjar.org.apache.hc.core5.reactor.IOReactorStatus;
import connectjar.org.apache.hc.core5.reactor.IOSession;
import connectjar.org.apache.hc.core5.util.TimeValue;
import connectjar.org.apache.hc.core5.util.Timeout;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpAsyncClientBase
extends CloseableHttpAsyncClient
implements ConnectionInitiator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHttpAsyncClientBase.class);
    private final AsyncPushConsumerRegistry pushConsumerRegistry;
    private final DefaultConnectingIOReactor ioReactor;
    private final ExecutorService executorService;
    private final AtomicReference<Status> status;

    AbstractHttpAsyncClientBase(DefaultConnectingIOReactor ioReactor, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory) {
        this.ioReactor = ioReactor;
        this.pushConsumerRegistry = pushConsumerRegistry;
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.status = new AtomicReference<Status>(Status.READY);
    }

    @Override
    public final void start() {
        if (this.status.compareAndSet(Status.READY, Status.RUNNING)) {
            this.executorService.execute(this.ioReactor::start);
        }
    }

    @Override
    @Deprecated
    public void register(String hostname, String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        this.pushConsumerRegistry.register(hostname, uriPattern, supplier);
    }

    boolean isRunning() {
        return this.status.get() == Status.RUNNING;
    }

    @Override
    public Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Timeout timeout, Object attachment, FutureCallback<IOSession> callback) {
        return this.ioReactor.connect(remoteEndpoint, remoteAddress, localAddress, timeout, attachment, callback);
    }

    ConnectionInitiator getConnectionInitiator() {
        return this.ioReactor;
    }

    @Override
    public final IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    public final void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public final void initiateShutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initiating shutdown");
        }
        this.ioReactor.initiateShutdown();
    }

    void internalClose(CloseMode closeMode) {
    }

    @Override
    public final void close(CloseMode closeMode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutdown {}", (Object)closeMode);
        }
        this.ioReactor.initiateShutdown();
        this.ioReactor.close(closeMode);
        if (closeMode == CloseMode.GRACEFUL) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.executorService.shutdownNow();
        }
        this.internalClose(closeMode);
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    static enum Status {
        READY,
        RUNNING,
        TERMINATED;

    }
}

