/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.client5.http.impl.async;

import connectjar.org.apache.hc.client5.http.HttpRoute;
import connectjar.org.apache.hc.client5.http.async.AsyncExecRuntime;
import connectjar.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import connectjar.org.apache.hc.client5.http.auth.CredentialsProvider;
import connectjar.org.apache.hc.client5.http.config.RequestConfig;
import connectjar.org.apache.hc.client5.http.cookie.CookieSpecFactory;
import connectjar.org.apache.hc.client5.http.cookie.CookieStore;
import connectjar.org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import connectjar.org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import connectjar.org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient;
import connectjar.org.apache.hc.client5.http.impl.async.InternalH2AsyncExecRuntime;
import connectjar.org.apache.hc.client5.http.impl.async.InternalH2ConnPool;
import connectjar.org.apache.hc.client5.http.protocol.HttpClientContext;
import connectjar.org.apache.hc.client5.http.routing.HttpRoutePlanner;
import connectjar.org.apache.hc.core5.annotation.Contract;
import connectjar.org.apache.hc.core5.annotation.Internal;
import connectjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import connectjar.org.apache.hc.core5.http.HttpException;
import connectjar.org.apache.hc.core5.http.HttpHost;
import connectjar.org.apache.hc.core5.http.HttpRequest;
import connectjar.org.apache.hc.core5.http.config.Lookup;
import connectjar.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import connectjar.org.apache.hc.core5.http.nio.HandlerFactory;
import connectjar.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public final class InternalH2AsyncClient
extends InternalAbstractHttpAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(InternalH2AsyncClient.class);
    private final HttpRoutePlanner routePlanner;
    private final InternalH2ConnPool connPool;

    InternalH2AsyncClient(DefaultConnectingIOReactor ioReactor, AsyncExecChainElement execChain, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, InternalH2ConnPool connPool, HttpRoutePlanner routePlanner, Lookup<CookieSpecFactory> cookieSpecRegistry, Lookup<AuthSchemeFactory> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory, execChain, cookieSpecRegistry, authSchemeRegistry, cookieStore, credentialsProvider, HttpClientContext::castOrCreate, defaultConfig, closeables);
        this.connPool = connPool;
        this.routePlanner = routePlanner;
    }

    @Override
    AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> pushHandlerFactory) {
        return new InternalH2AsyncExecRuntime(LOG, this.connPool, pushHandlerFactory);
    }

    @Override
    HttpRoute determineRoute(HttpHost httpHost, HttpRequest request, HttpClientContext clientContext) throws HttpException {
        HttpRoute route = this.routePlanner.determineRoute(httpHost, request, clientContext);
        if (route.isTunnelled()) {
            throw new HttpException("HTTP/2 tunneling not supported");
        }
        return route;
    }
}

