/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.client5.http.impl.async;

import connectjar.org.apache.hc.client5.http.HttpRoute;
import connectjar.org.apache.hc.client5.http.config.ConnectionConfig;
import connectjar.org.apache.hc.core5.concurrent.CallbackContribution;
import connectjar.org.apache.hc.core5.concurrent.FutureCallback;
import connectjar.org.apache.hc.core5.function.Callback;
import connectjar.org.apache.hc.core5.function.Resolver;
import connectjar.org.apache.hc.core5.http.HttpHost;
import connectjar.org.apache.hc.core5.http.URIScheme;
import connectjar.org.apache.hc.core5.http.nio.command.ShutdownCommand;
import connectjar.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import connectjar.org.apache.hc.core5.http2.nio.command.PingCommand;
import connectjar.org.apache.hc.core5.http2.nio.support.BasicPingHandler;
import connectjar.org.apache.hc.core5.io.CloseMode;
import connectjar.org.apache.hc.core5.io.ModalCloseable;
import connectjar.org.apache.hc.core5.net.NamedEndpoint;
import connectjar.org.apache.hc.core5.reactor.AbstractIOSessionPool;
import connectjar.org.apache.hc.core5.reactor.Command;
import connectjar.org.apache.hc.core5.reactor.ConnectionInitiator;
import connectjar.org.apache.hc.core5.reactor.IOSession;
import connectjar.org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import connectjar.org.apache.hc.core5.util.TimeValue;
import connectjar.org.apache.hc.core5.util.Timeout;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;

class InternalH2ConnPool
implements ModalCloseable {
    private final SessionPool sessionPool;
    private volatile Resolver<HttpHost, ConnectionConfig> connectionConfigResolver;

    InternalH2ConnPool(ConnectionInitiator connectionInitiator, Resolver<HttpHost, InetSocketAddress> addressResolver, TlsStrategy tlsStrategy) {
        this.sessionPool = new SessionPool(connectionInitiator, addressResolver, tlsStrategy);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.sessionPool.close(closeMode);
    }

    @Override
    public void close() {
        this.sessionPool.close();
    }

    private ConnectionConfig resolveConnectionConfig(HttpHost httpHost) {
        Resolver<HttpHost, ConnectionConfig> resolver = this.connectionConfigResolver;
        ConnectionConfig connectionConfig = resolver != null ? resolver.resolve(httpHost) : null;
        return connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
    }

    public Future<IOSession> getSession(HttpRoute route, Timeout connectTimeout, final FutureCallback<IOSession> callback) {
        final ConnectionConfig connectionConfig = this.resolveConnectionConfig(route.getTargetHost());
        return this.sessionPool.getSession(route, connectTimeout != null ? connectTimeout : connectionConfig.getConnectTimeout(), (FutureCallback<IOSession>)new CallbackContribution<IOSession>(callback){

            @Override
            public void completed(IOSession ioSession) {
                Timeout socketTimeout = connectionConfig.getSocketTimeout();
                if (socketTimeout != null) {
                    ioSession.setSocketTimeout(socketTimeout);
                }
                callback.completed(ioSession);
            }
        });
    }

    public void closeIdle(TimeValue idleTime) {
        this.sessionPool.closeIdle(idleTime);
    }

    public void setConnectionConfigResolver(Resolver<HttpHost, ConnectionConfig> connectionConfigResolver) {
        this.connectionConfigResolver = connectionConfigResolver;
    }

    public TimeValue getValidateAfterInactivity() {
        return this.sessionPool.validateAfterInactivity;
    }

    public void setValidateAfterInactivity(TimeValue timeValue) {
        this.sessionPool.validateAfterInactivity = timeValue;
    }

    static class SessionPool
    extends AbstractIOSessionPool<HttpRoute> {
        private final ConnectionInitiator connectionInitiator;
        private final Resolver<HttpHost, InetSocketAddress> addressResolver;
        private final TlsStrategy tlsStrategy;
        private volatile TimeValue validateAfterInactivity = TimeValue.NEG_ONE_MILLISECOND;

        SessionPool(ConnectionInitiator connectionInitiator, Resolver<HttpHost, InetSocketAddress> addressResolver, TlsStrategy tlsStrategy) {
            this.connectionInitiator = connectionInitiator;
            this.addressResolver = addressResolver;
            this.tlsStrategy = tlsStrategy;
        }

        @Override
        protected Future<IOSession> connectSession(final HttpRoute route, final Timeout connectTimeout, final FutureCallback<IOSession> callback) {
            final HttpHost target = route.getTargetHost();
            InetSocketAddress localAddress = route.getLocalSocketAddress();
            InetSocketAddress remoteAddress = this.addressResolver.resolve(target);
            return this.connectionInitiator.connect(target, remoteAddress, localAddress, connectTimeout, null, (FutureCallback<IOSession>)new CallbackContribution<IOSession>(callback){

                @Override
                public void completed(final IOSession ioSession) {
                    if (tlsStrategy != null && URIScheme.HTTPS.same(target.getSchemeName()) && ioSession instanceof TransportSecurityLayer) {
                        NamedEndpoint tlsName = route.getTargetName() != null ? route.getTargetName() : target;
                        tlsStrategy.upgrade((TransportSecurityLayer)((Object)ioSession), tlsName, null, connectTimeout, (FutureCallback<TransportSecurityLayer>)new CallbackContribution<TransportSecurityLayer>(callback){

                            @Override
                            public void completed(TransportSecurityLayer transportSecurityLayer) {
                                callback.completed(ioSession);
                            }
                        });
                        ioSession.setSocketTimeout(connectTimeout);
                    } else {
                        callback.completed(ioSession);
                    }
                }
            });
        }

        @Override
        protected void validateSession(IOSession ioSession, Callback<Boolean> callback) {
            if (ioSession.isOpen()) {
                long lastAccessTime;
                long deadline;
                TimeValue timeValue = this.validateAfterInactivity;
                if (TimeValue.isNonNegative(timeValue) && (deadline = (lastAccessTime = Math.min(ioSession.getLastReadTime(), ioSession.getLastWriteTime())) + timeValue.toMilliseconds()) <= System.currentTimeMillis()) {
                    Timeout socketTimeoutMillis = ioSession.getSocketTimeout();
                    ioSession.enqueue(new PingCommand(new BasicPingHandler(result -> {
                        ioSession.setSocketTimeout(socketTimeoutMillis);
                        callback.execute((Boolean)result);
                    })), Command.Priority.NORMAL);
                    return;
                }
                callback.execute(true);
            } else {
                callback.execute(false);
            }
        }

        @Override
        protected void closeSession(IOSession ioSession, CloseMode closeMode) {
            if (closeMode == CloseMode.GRACEFUL) {
                ioSession.enqueue(ShutdownCommand.GRACEFUL, Command.Priority.NORMAL);
            } else {
                ioSession.close(closeMode);
            }
        }
    }
}

