/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.client5.http.impl.io;

import connectjar.org.apache.hc.client5.http.ConnectExceptionSupport;
import connectjar.org.apache.hc.client5.http.DnsResolver;
import connectjar.org.apache.hc.client5.http.SchemePortResolver;
import connectjar.org.apache.hc.client5.http.SystemDefaultDnsResolver;
import connectjar.org.apache.hc.client5.http.UnsupportedSchemeException;
import connectjar.org.apache.hc.client5.http.config.TlsConfig;
import connectjar.org.apache.hc.client5.http.impl.ConnPoolSupport;
import connectjar.org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import connectjar.org.apache.hc.client5.http.io.DetachedSocketFactory;
import connectjar.org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import connectjar.org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import connectjar.org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import connectjar.org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import connectjar.org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import connectjar.org.apache.hc.core5.annotation.Contract;
import connectjar.org.apache.hc.core5.annotation.Internal;
import connectjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import connectjar.org.apache.hc.core5.http.ConnectionClosedException;
import connectjar.org.apache.hc.core5.http.HttpHost;
import connectjar.org.apache.hc.core5.http.URIScheme;
import connectjar.org.apache.hc.core5.http.config.Lookup;
import connectjar.org.apache.hc.core5.http.io.SocketConfig;
import connectjar.org.apache.hc.core5.http.protocol.HttpContext;
import connectjar.org.apache.hc.core5.io.Closer;
import connectjar.org.apache.hc.core5.io.SocketSupport;
import connectjar.org.apache.hc.core5.net.NamedEndpoint;
import connectjar.org.apache.hc.core5.util.Args;
import connectjar.org.apache.hc.core5.util.TimeValue;
import connectjar.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultHttpClientConnectionOperator
implements HttpClientConnectionOperator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClientConnectionOperator.class);
    static final DetachedSocketFactory PLAIN_SOCKET_FACTORY = socksProxy -> socksProxy == null ? new Socket() : new Socket(socksProxy);
    private final DetachedSocketFactory detachedSocketFactory;
    private final Lookup<TlsSocketStrategy> tlsSocketStrategyLookup;
    private final SchemePortResolver schemePortResolver;
    private final DnsResolver dnsResolver;

    @Deprecated
    static Lookup<TlsSocketStrategy> adapt(Lookup<ConnectionSocketFactory> lookup) {
        return name -> {
            ConnectionSocketFactory sf = (ConnectionSocketFactory)lookup.lookup(name);
            return sf instanceof LayeredConnectionSocketFactory ? (socket, target, port, attachment, context) -> (SSLSocket)((LayeredConnectionSocketFactory)sf).createLayeredSocket(socket, target, port, attachment, context) : null;
        };
    }

    public DefaultHttpClientConnectionOperator(DetachedSocketFactory detachedSocketFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, Lookup<TlsSocketStrategy> tlsSocketStrategyLookup) {
        this.detachedSocketFactory = Args.notNull(detachedSocketFactory, "Plain socket factory");
        this.tlsSocketStrategyLookup = Args.notNull(tlsSocketStrategyLookup, "Socket factory registry");
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    @Deprecated
    public DefaultHttpClientConnectionOperator(Lookup<ConnectionSocketFactory> socketFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(PLAIN_SOCKET_FACTORY, schemePortResolver, dnsResolver, DefaultHttpClientConnectionOperator.adapt(socketFactoryRegistry));
    }

    public DefaultHttpClientConnectionOperator(SchemePortResolver schemePortResolver, DnsResolver dnsResolver, Lookup<TlsSocketStrategy> tlsSocketStrategyLookup) {
        this(PLAIN_SOCKET_FACTORY, schemePortResolver, dnsResolver, tlsSocketStrategyLookup);
    }

    @Override
    public void connect(ManagedHttpClientConnection conn, HttpHost host, InetSocketAddress localAddress, TimeValue connectTimeout, SocketConfig socketConfig, HttpContext context) throws IOException {
        Timeout timeout = connectTimeout != null ? Timeout.of(connectTimeout.getDuration(), connectTimeout.getTimeUnit()) : null;
        this.connect(conn, host, null, localAddress, timeout, socketConfig, null, context);
    }

    @Override
    public void connect(ManagedHttpClientConnection conn, HttpHost endpointHost, NamedEndpoint endpointName, InetSocketAddress localAddress, Timeout connectTimeout, SocketConfig socketConfig, Object attachment, HttpContext context) throws IOException {
        List<InetSocketAddress> remoteAddresses;
        Proxy socksProxy;
        Args.notNull(conn, "Connection");
        Args.notNull(endpointHost, "Host");
        Args.notNull(socketConfig, "Socket config");
        Args.notNull(context, "Context");
        SocketAddress socksProxyAddress = socketConfig.getSocksProxyAddress();
        Proxy proxy = socksProxy = socksProxyAddress != null ? new Proxy(Proxy.Type.SOCKS, socksProxyAddress) : null;
        if (endpointHost.getAddress() != null) {
            remoteAddresses = Collections.singletonList(new InetSocketAddress(endpointHost.getAddress(), this.schemePortResolver.resolve(endpointHost.getSchemeName(), endpointHost)));
        } else {
            int port = this.schemePortResolver.resolve(endpointHost.getSchemeName(), endpointHost);
            remoteAddresses = this.dnsResolver.resolve(endpointHost.getHostName(), port);
        }
        for (int i2 = 0; i2 < remoteAddresses.size(); ++i2) {
            InetSocketAddress remoteAddress = remoteAddresses.get(i2);
            boolean last = i2 == remoteAddresses.size() - 1;
            this.onBeforeSocketConnect(context, endpointHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} connecting {}->{} ({})", new Object[]{endpointHost, localAddress, remoteAddress, connectTimeout});
            }
            Socket socket = this.detachedSocketFactory.create(endpointHost.getSchemeName(), socksProxy);
            try {
                TlsSocketStrategy tlsSocketStrategy;
                int linger;
                if (localAddress != null) {
                    socket.bind(localAddress);
                }
                conn.bind(socket);
                Timeout socketTimeout = socketConfig.getSoTimeout();
                if (socketTimeout != null) {
                    socket.setSoTimeout(socketTimeout.toMillisecondsIntBound());
                }
                socket.setReuseAddress(socketConfig.isSoReuseAddress());
                socket.setTcpNoDelay(socketConfig.isTcpNoDelay());
                socket.setKeepAlive(socketConfig.isSoKeepAlive());
                if (socketConfig.getRcvBufSize() > 0) {
                    socket.setReceiveBufferSize(socketConfig.getRcvBufSize());
                }
                if (socketConfig.getSndBufSize() > 0) {
                    socket.setSendBufferSize(socketConfig.getSndBufSize());
                }
                if (socketConfig.getTcpKeepIdle() > 0) {
                    SocketSupport.setOption(socket, "TCP_KEEPIDLE", socketConfig.getTcpKeepIdle());
                }
                if (socketConfig.getTcpKeepInterval() > 0) {
                    SocketSupport.setOption(socket, "TCP_KEEPINTERVAL", socketConfig.getTcpKeepInterval());
                }
                if (socketConfig.getTcpKeepCount() > 0) {
                    SocketSupport.setOption(socket, "TCP_KEEPCOUNT", socketConfig.getTcpKeepCount());
                }
                if ((linger = socketConfig.getSoLinger().toMillisecondsIntBound()) >= 0) {
                    socket.setSoLinger(true, linger);
                }
                socket.connect(remoteAddress, TimeValue.isPositive(connectTimeout) ? connectTimeout.toMillisecondsIntBound() : 0);
                conn.bind(socket);
                this.onAfterSocketConnect(context, endpointHost);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} {} connected {}->{}", new Object[]{ConnPoolSupport.getId(conn), endpointHost, conn.getLocalAddress(), conn.getRemoteAddress()});
                }
                TlsSocketStrategy tlsSocketStrategy2 = tlsSocketStrategy = this.tlsSocketStrategyLookup != null ? this.tlsSocketStrategyLookup.lookup(endpointHost.getSchemeName()) : null;
                if (tlsSocketStrategy != null) {
                    Timeout handshakeTimeout;
                    NamedEndpoint tlsName = endpointName != null ? endpointName : endpointHost;
                    this.onBeforeTlsHandshake(context, endpointHost);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} {} upgrading to TLS", (Object)ConnPoolSupport.getId(conn), (Object)tlsName);
                    }
                    TlsConfig tlsConfig = attachment instanceof TlsConfig ? (TlsConfig)attachment : TlsConfig.DEFAULT;
                    int soTimeout = socket.getSoTimeout();
                    Timeout timeout = handshakeTimeout = tlsConfig.getHandshakeTimeout() != null ? tlsConfig.getHandshakeTimeout() : connectTimeout;
                    if (handshakeTimeout != null) {
                        socket.setSoTimeout(handshakeTimeout.toMillisecondsIntBound());
                    }
                    SSLSocket sslSocket = tlsSocketStrategy.upgrade(socket, tlsName.getHostName(), tlsName.getPort(), attachment, context);
                    conn.bind(sslSocket, socket);
                    socket.setSoTimeout(soTimeout);
                    this.onAfterTlsHandshake(context, endpointHost);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} {} upgraded to TLS", (Object)ConnPoolSupport.getId(conn), (Object)tlsName);
                    }
                }
                return;
            }
            catch (RuntimeException ex) {
                Closer.closeQuietly(socket);
                throw ex;
            }
            catch (IOException ex) {
                Closer.closeQuietly(socket);
                if (last) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} connection to {} failed ({}); terminating operation", new Object[]{endpointHost, remoteAddress, ex.getClass()});
                    }
                    throw ConnectExceptionSupport.enhance(ex, endpointHost, new InetAddress[0]);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} connection to {} failed ({}); retrying connection to the next address", new Object[]{endpointHost, remoteAddress, ex.getClass()});
                continue;
            }
        }
    }

    @Override
    public void upgrade(ManagedHttpClientConnection conn, HttpHost host, HttpContext context) throws IOException {
        this.upgrade(conn, host, null, null, context);
    }

    @Override
    public void upgrade(ManagedHttpClientConnection conn, HttpHost endpointHost, NamedEndpoint endpointName, Object attachment, HttpContext context) throws IOException {
        TlsSocketStrategy tlsSocketStrategy;
        Socket socket = conn.getSocket();
        if (socket == null) {
            throw new ConnectionClosedException("Connection is closed");
        }
        String newProtocol = URIScheme.HTTP.same(endpointHost.getSchemeName()) ? URIScheme.HTTPS.id : endpointHost.getSchemeName();
        TlsSocketStrategy tlsSocketStrategy2 = tlsSocketStrategy = this.tlsSocketStrategyLookup != null ? this.tlsSocketStrategyLookup.lookup(newProtocol) : null;
        if (tlsSocketStrategy != null) {
            NamedEndpoint tlsName = endpointName != null ? endpointName : endpointHost;
            this.onBeforeTlsHandshake(context, endpointHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} upgrading to TLS {}:{}", new Object[]{ConnPoolSupport.getId(conn), tlsName.getHostName(), tlsName.getPort()});
            }
            SSLSocket upgradedSocket = tlsSocketStrategy.upgrade(socket, tlsName.getHostName(), tlsName.getPort(), attachment, context);
            conn.bind(upgradedSocket, socket);
            this.onAfterTlsHandshake(context, endpointHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} upgraded to TLS {}:{}", new Object[]{ConnPoolSupport.getId(conn), tlsName.getHostName(), tlsName.getPort()});
            }
        } else {
            throw new UnsupportedSchemeException(newProtocol + " protocol is not supported");
        }
    }

    protected void onBeforeSocketConnect(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onAfterSocketConnect(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onBeforeTlsHandshake(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onAfterTlsHandshake(HttpContext httpContext, HttpHost endpointHost) {
    }
}

