/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.core5.http.impl.bootstrap;

import connectjar.org.apache.hc.core5.http.ExceptionListener;
import connectjar.org.apache.hc.core5.http.impl.io.HttpService;
import connectjar.org.apache.hc.core5.http.io.HttpServerConnection;
import connectjar.org.apache.hc.core5.http.protocol.HttpCoreContext;
import connectjar.org.apache.hc.core5.io.CloseMode;

class Worker
implements Runnable {
    private final HttpService httpservice;
    private final HttpServerConnection conn;
    private final ExceptionListener exceptionListener;

    Worker(HttpService httpservice, HttpServerConnection conn, ExceptionListener exceptionListener) {
        this.httpservice = httpservice;
        this.conn = conn;
        this.exceptionListener = exceptionListener;
    }

    public HttpServerConnection getConnection() {
        return this.conn;
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted() && this.conn.isOpen()) {
                HttpCoreContext context = HttpCoreContext.create();
                this.httpservice.handleRequest(this.conn, context);
            }
            this.conn.close();
        }
        catch (Exception ex) {
            this.exceptionListener.onError(this.conn, ex);
        }
        finally {
            this.conn.close(CloseMode.IMMEDIATE);
        }
    }
}

