/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.core5.http.protocol;

import connectjar.org.apache.hc.core5.annotation.Contract;
import connectjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import connectjar.org.apache.hc.core5.http.EntityDetails;
import connectjar.org.apache.hc.core5.http.Header;
import connectjar.org.apache.hc.core5.http.HttpException;
import connectjar.org.apache.hc.core5.http.HttpRequest;
import connectjar.org.apache.hc.core5.http.HttpRequestInterceptor;
import connectjar.org.apache.hc.core5.http.HttpVersion;
import connectjar.org.apache.hc.core5.http.ProtocolException;
import connectjar.org.apache.hc.core5.http.ProtocolVersion;
import connectjar.org.apache.hc.core5.http.protocol.HttpContext;
import connectjar.org.apache.hc.core5.net.URIAuthority;
import connectjar.org.apache.hc.core5.util.Args;
import java.io.IOException;
import java.net.URISyntaxException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestValidateHost
implements HttpRequestInterceptor {
    public static final RequestValidateHost INSTANCE = new RequestValidateHost();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request.getAuthority() != null) {
            return;
        }
        Header header = request.getHeader("Host");
        if (header != null) {
            URIAuthority authority;
            try {
                authority = URIAuthority.create(header.getValue());
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException(ex.getMessage(), ex);
            }
            request.setAuthority(authority);
        } else {
            ProtocolVersion version;
            ProtocolVersion protocolVersion = version = request.getVersion() != null ? request.getVersion() : HttpVersion.HTTP_1_1;
            if (version.greaterEquals(HttpVersion.HTTP_1_1)) {
                throw new ProtocolException("Host header is absent");
            }
        }
    }
}

