/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.core5.http2.impl.nio;

import connectjar.org.apache.hc.core5.annotation.Contract;
import connectjar.org.apache.hc.core5.annotation.Internal;
import connectjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import connectjar.org.apache.hc.core5.concurrent.FutureCallback;
import connectjar.org.apache.hc.core5.function.Callback;
import connectjar.org.apache.hc.core5.http2.impl.nio.ServerH2PrefaceHandler;
import connectjar.org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import connectjar.org.apache.hc.core5.reactor.ProtocolIOSession;
import connectjar.org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import connectjar.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ServerH2UpgradeHandler
implements ProtocolUpgradeHandler {
    private final ServerH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final Callback<Exception> exceptionCallback;

    public ServerH2UpgradeHandler(ServerH2StreamMultiplexerFactory http2StreamHandlerFactory, Callback<Exception> exceptionCallback) {
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.exceptionCallback = exceptionCallback;
    }

    @Override
    public void upgrade(ProtocolIOSession ioSession, FutureCallback<ProtocolIOSession> callback) {
        ServerH2PrefaceHandler protocolNegotiator = new ServerH2PrefaceHandler(ioSession, this.http2StreamHandlerFactory, callback, this.exceptionCallback);
        ioSession.upgrade(protocolNegotiator);
        try {
            protocolNegotiator.connected(ioSession);
        }
        catch (IOException ex) {
            protocolNegotiator.exception(ioSession, ex);
        }
    }
}

