/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.connect.httpclient.impl;

import connectjar.org.apache.hc.client5.http.classic.methods.HttpDelete;
import connectjar.org.apache.hc.client5.http.classic.methods.HttpGet;
import connectjar.org.apache.hc.client5.http.classic.methods.HttpHead;
import connectjar.org.apache.hc.client5.http.classic.methods.HttpOptions;
import connectjar.org.apache.hc.client5.http.classic.methods.HttpPatch;
import connectjar.org.apache.hc.client5.http.classic.methods.HttpPost;
import connectjar.org.apache.hc.client5.http.classic.methods.HttpPut;
import connectjar.org.apache.hc.client5.http.classic.methods.HttpTrace;
import connectjar.org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import connectjar.org.apache.hc.client5.http.config.RequestConfig;
import connectjar.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import connectjar.org.apache.hc.client5.http.impl.classic.HttpClients;
import connectjar.org.apache.hc.core5.http.ClassicHttpResponse;
import connectjar.org.apache.hc.core5.http.ContentType;
import connectjar.org.apache.hc.core5.http.io.entity.InputStreamEntity;
import connectjar.org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import io.openbpm.connect.httpclient.HttpBaseRequest;
import io.openbpm.connect.httpclient.HttpResponse;
import io.openbpm.connect.httpclient.impl.HttpConnectorLogger;
import io.openbpm.connect.httpclient.impl.HttpLogger;
import io.openbpm.connect.httpclient.impl.HttpRequestInvocation;
import io.openbpm.connect.httpclient.impl.util.ParseUtil;
import io.openbpm.connect.impl.AbstractConnector;
import io.openbpm.connect.spi.ConnectorRequest;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractHttpConnector<Q extends HttpBaseRequest<Q, R>, R extends HttpResponse>
extends AbstractConnector<Q, R> {
    protected static final HttpConnectorLogger LOG = HttpLogger.HTTP_LOGGER;
    protected CloseableHttpClient httpClient = this.createClient();
    protected final Charset charset = StandardCharsets.UTF_8;

    protected AbstractHttpConnector(String connectorId) {
        super(connectorId);
    }

    protected CloseableHttpClient createClient() {
        return HttpClients.createSystem();
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public R execute(Q request) {
        R invocationResult;
        Object httpRequest = this.createHttpRequest(request);
        HttpRequestInvocation invocation = new HttpRequestInvocation((BasicClassicHttpRequest)httpRequest, (ConnectorRequest<?>)request, this.requestInterceptors, this.httpClient);
        try {
            invocationResult = this.createResponse((ClassicHttpResponse)invocation.proceed());
        }
        catch (Exception e) {
            throw LOG.unableToExecuteRequest(e);
        }
        this.handleErrorResponse(request, invocationResult);
        return invocationResult;
    }

    protected void handleErrorResponse(Q request, R invocationResult) {
        Map<String, Object> configOptions = request.getConfigOptions();
        if (configOptions != null && invocationResult != null) {
            int statusCode = invocationResult.getStatusCode();
            String connectorResponse = invocationResult.getResponse();
            Object handleHttpError = Optional.ofNullable(configOptions.get("throw-http-error")).orElse("FALSE");
            if (Boolean.parseBoolean(handleHttpError.toString()) && statusCode >= 400 && statusCode <= 599) {
                throw LOG.httpRequestError(statusCode, connectorResponse);
            }
        }
    }

    protected abstract R createResponse(ClassicHttpResponse var1);

    protected <T extends BasicClassicHttpRequest> T createHttpRequest(Q request) {
        T httpRequest = this.createHttpRequestBase(request);
        this.applyConfig(httpRequest, request.getConfigOptions());
        this.applyHeaders(httpRequest, request.getHeaders());
        this.applyPayload(httpRequest, request);
        return httpRequest;
    }

    protected <T extends BasicClassicHttpRequest> T createHttpRequestBase(Q request) {
        String url = request.getUrl();
        if (url != null && !url.trim().isEmpty()) {
            String method = request.getMethod();
            if ("GET".equals(method)) {
                return (T)new HttpGet(url);
            }
            if ("POST".equals(method)) {
                return (T)new HttpPost(url);
            }
            if ("PUT".equals(method)) {
                return (T)new HttpPut(url);
            }
            if ("DELETE".equals(method)) {
                return (T)new HttpDelete(url);
            }
            if ("PATCH".equals(method)) {
                return (T)new HttpPatch(url);
            }
            if ("HEAD".equals(method)) {
                return (T)new HttpHead(url);
            }
            if ("OPTIONS".equals(method)) {
                return (T)new HttpOptions(url);
            }
            if ("TRACE".equals(method)) {
                return (T)new HttpTrace(url);
            }
            throw LOG.unknownHttpMethod(method);
        }
        throw LOG.requestUrlRequired();
    }

    protected <T extends BasicClassicHttpRequest> void applyHeaders(T httpRequest, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequest.setHeader(entry.getKey(), entry.getValue());
                LOG.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    protected <T extends BasicClassicHttpRequest> void applyPayload(T httpRequest, Q request) {
        if (this.httpMethodSupportsPayload(httpRequest)) {
            if (request.getPayload() != null) {
                byte[] bytes = request.getPayload().getBytes(this.charset);
                ByteArrayInputStream payload = new ByteArrayInputStream(bytes);
                InputStreamEntity entity = new InputStreamEntity(payload, bytes.length, ContentType.parse(request.getContentType()));
                httpRequest.setEntity(entity);
            }
        } else if (request.getPayload() != null) {
            LOG.payloadIgnoredForHttpMethod(request.getMethod());
        }
    }

    protected <T extends BasicClassicHttpRequest> boolean httpMethodSupportsPayload(T httpRequest) {
        return httpRequest instanceof HttpUriRequestBase;
    }

    protected <T extends BasicClassicHttpRequest> void applyConfig(T httpRequest, Map<String, Object> configOptions) {
        if (this.httpMethodSupportsPayload(httpRequest)) {
            RequestConfig.Builder configBuilder = RequestConfig.custom();
            if (configOptions != null && !configOptions.isEmpty()) {
                ParseUtil.parseConfigOptions(configOptions, configBuilder);
            }
            RequestConfig requestConfig = configBuilder.build();
            ((HttpUriRequestBase)httpRequest).setConfig(requestConfig);
        }
    }
}

