/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.connect.httpclient.impl;

import connectjar.org.apache.hc.core5.http.ClassicHttpResponse;
import connectjar.org.apache.hc.core5.http.Header;
import io.openbpm.commons.utils.IoUtil;
import io.openbpm.connect.httpclient.HttpResponse;
import io.openbpm.connect.httpclient.impl.HttpConnectorLogger;
import io.openbpm.connect.httpclient.impl.HttpLogger;
import io.openbpm.connect.impl.AbstractCloseableConnectorResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class HttpResponseImpl
extends AbstractCloseableConnectorResponse
implements HttpResponse {
    private static final HttpConnectorLogger LOG = HttpLogger.HTTP_LOGGER;
    protected ClassicHttpResponse httpResponse;

    public HttpResponseImpl(ClassicHttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    @Override
    public Integer getStatusCode() {
        return (Integer)this.getResponseParameter("statusCode");
    }

    @Override
    public String getResponse() {
        return (String)this.getResponseParameter("response");
    }

    @Override
    public Map<String, String> getHeaders() {
        return (Map)this.getResponseParameter("headers");
    }

    @Override
    public String getHeader(String field) {
        Map<String, String> headers = this.getHeaders();
        if (headers != null) {
            return headers.get(field);
        }
        return null;
    }

    protected void collectResponseParameters(Map<String, Object> responseParameters) {
        responseParameters.put("statusCode", this.httpResponse.getCode());
        this.collectResponseHeaders();
        if (this.httpResponse.getEntity() != null) {
            try {
                String response = IoUtil.inputStreamAsString((InputStream)this.httpResponse.getEntity().getContent());
                responseParameters.put("response", response);
            }
            catch (IOException e) {
                throw LOG.unableToReadResponse(e);
            }
            finally {
                IoUtil.closeSilently((Closeable)this.httpResponse);
            }
        }
    }

    protected void collectResponseHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : this.httpResponse.getHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        this.responseParameters.put("headers", headers);
    }

    protected Closeable getClosable() {
        return this.httpResponse;
    }
}

