/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.AnnotatedElement;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.StringUtils;

class DisabledCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled("@Disabled is not present");

    DisabledCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        AnnotatedElement element = context.getElement().orElse(null);
        return AnnotationSupport.findAnnotation(element, Disabled.class).map(annotation -> this.toResult(element, (Disabled)annotation)).orElse(ENABLED);
    }

    private ConditionEvaluationResult toResult(AnnotatedElement element, Disabled annotation) {
        String value = annotation.value();
        String reason = StringUtils.isNotBlank(value) ? value : element + " is @Disabled";
        return ConditionEvaluationResult.disabled(reason);
    }
}

